use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {};  my $manpage = {};
foreach my $module ( qw( TCB::System TCB::System::Misc TCB::System::Room
			 TCB::System::OS TCB::System::UsrLocal
			 TCB::System::Building ) ) {
  my $file = $module;
     $file =~ s/::/\//g;  
     $file =~ s/$/.pm/;
  my $shortfile = $file;  $shortfile =~ s%^TCB/%%;
  my $libdir = join('/', '$(INST_LIBDIR)', $shortfile);
  my $man3 = join('/', '$(INST_MAN3DIR)', "$module.3");
  $$modules{$file} = $libdir; $$manpage{$file} = $man3;
}

my @progs;
foreach ( qw( htaccess-base htgroup-base htpasswd-base stylesheet.css
	system/admin_all.cgi system/admin.cgi system/user_all.cgi 
	system/user.cgi ) ) {
  push @progs, "cgi-bin/$_";
}
my $progs = [ 'system_create.pl', @progs ] ;

WriteMakefile(
    'NAME'	=> 'TCB::System',
    'DISTNAME'  => 'TCB-System',
    'MAN3PODS'  => $manpage, 
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'PREREQ_PM' => { 'DBIx::Frame' => 1.05 },
    'PM' 	=> $modules,
    'EXE_FILES' => $progs,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/System.pm',
);
