#!/usr/local/bin/perl 
use vars qw( $DB $DEBUG $DATABASE $DBHOST $DBTYPE $DBUSER $DBPASS $HTML 
	     $CONVERT $PSTOIMG $VERSION $LATEX2HTML $CLASS );
our $VERSION = "1.0";

=head1 NAME

abstract.pl - extract abstract information from TCB::Publications

=head1 SYNOPSIS

  mkdir -p /home/papers/abstracts
  cd /home/papers/abstracts
  ln -s /usr/local/bin/latex2html .
  abstract.pl 
   
    -later rebuilding- 

  cd /home/papers/abstracts
  rm -rf AKSI2004
  abstract.pl AKSI2004

=head1 DESCRIPTION

abstract.pl is used to extract abstract information from the
TCB::Publications database, and parse the information into individual HTML
files for later use.  This uses the LaTeX2HTML package, which makes the
prettiest but most complex HTML at present.

=head1 REQUIREMENTS

LaTeX2HTML, B<TCB::Publications>, B<CGI::SHTML>

=head1 SEE ALSO

B<http://www.latex2html.org/>, B<TCB::Publications>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut


###############################################################################
### Configuration + Private Data ##############################################
###############################################################################

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  
# do '/FULL/PATH/TO/CODE/TO/RUN';       

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Publications";                 # Database class

## Modify and uncomment this to use user code instead of just system-wide
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless
## you're a developer.

# use lib '/PATH/TO/CODE';
use lib '/home/tskirvin/dev/mdtools/tcb-publications';

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";               # System that hosts the database
# $DBTYPE   = "";               # The type of database that we're working on
# $DATABASE = "";               # Name of the database we're connecting to
# $DBUSER   = "";               # Username to connect to the database
# $DBPASS   = "";               # Password to connect to the database
do '/home/webserver/dbaccess/user.pubdb';     # Populate DBUSER, DBPASS, etc

## How do you convert from the LaTeX abstracts in the database to HTML?

$LATEX2HTML = "./latex2html";	# It's in the local directory
$CONVERT  = "$LATEX2HTML -nonavigation -noinfo -noaddress -antialias -transparent";

## Print debugging information?
$DEBUG    = 0;

###############################################################################
### main() ####################################################################
###############################################################################

use DBIx::Frame;
use strict;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }
$0 =~ s%.*/%%g;         # Lose the annoying path information

our $PAPER;
if (@ARGV) { $PAPER = shift @ARGV; } else { $PAPER = ".*" }

$DB = TCB::Publications->connect( $DATABASE, $DBUSER, $DBPASS )
              or Error("Couldn't connect to database: $DBI::errstr\n");

my %codes;
foreach my $data ($DB->select('Papers', { })) {
  next unless $data;  next unless ref $data; 
  $codes{$$data{TBCode}} = $data if $$data{TBCode};
}

foreach my $code (sort keys %codes) {
  next unless $code;  
  next unless $code =~ /^$PAPER$/;
  my $data = $codes{$code};	
  my $abstract = $$data{'Abstract'};   next unless $abstract;
  next if (-d "$code");
  open (FILE, ">$code.tex");
  print FILE $abstract;
  close FILE;
  system("$CONVERT $code");
  unlink("$code.tex");
}

foreach (sort keys %codes) {
  next if ($PAPER ne '.*');
  next unless $_;  
  unless (-d "$_") { warn "Directory $_ does not exist!\n"; }
}

sub Error {
  print "This script failed for the following reasons:\n";
  foreach (@_) { next unless $_; print " - ", canon($_), "\n"; }

  if ($DEBUG) {
    print "SQL Queries:\n";
    foreach ($DB->queries) { print " - $_\n" }
  }

  exit(0);
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.0		Mon May 17 14:49:49 CDT 2004 
### Finally cleaned it up enough to have a version number.
