#!/usr/local/bin/perl -T
use vars qw( $DBHOST $DBTYPE $DATABASE $DBUSER $DBPASS $DEBUG $CLASS $DB $HTML 
             $OPTIONS $TITLE @ACTIONS $HTMLHEAD $HTMLFOOT $HTMLBODY $VERSION 
	     $ROOTCLASS $STYLESHEET );
$VERSION = "1.5.1"; 	

=head1 NAME

paper_internal.cgi - Internal access to TCB::Publications database

=head1 SYNOPSIS

Unfortunately, no URL is available for public use.  You can see the man
pages for DBIx::Frame::CGI for some details, otherwise you probably just
want to try it out.

=head1 DESCRIPTION

paper_internal.cgi is a heavily customized version of DBIx::Frame's
dbixframe.cgi, with updates made to allow internal users to look at
database information effectively without having access to the tools to
actually modify the data.  It's essentially a halfway point between the
public interface and the administrative interface, and more complicated
than either.

=head1 REQUIREMENTS

B<TCB::Publications>

=head1 SEE ALSO

B<TCB::Publications>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Configuration + Private Data ##############################################
###############################################################################

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  

# do '/FULL/PATH/TO/CODE/TO/RUN';	
use TCB::Internal;

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Publications::Papers";			# Database class

## This is the root class of the above class.  Essentially a hack to let
## there be multiple modules using the same database.

$ROOTCLASS = "TCB::Publications";               # Class of the database class

## Modify and uncomment this to use user code instead of just system-wide 
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless you're
## a developer.

# use lib '/PATH/TO/USER/CODE';
# use lib '/home/tskirvin/dev/mdtools/tcb-publications';

## Document title - set this as appropriate.

$TITLE   = "Publications Database - Internal";		

## Set these options to modify the behaviour of the HTML creation code.

$OPTIONS = { 					
	'admin'    => 0, 	# Offer 'edit' and 'delete' functions?
	'nodetail' => 1, 	# Don't offer 'view'?
	'nomenu'   => 1,	# Don't include the bottom menu?
	'nocount'  => 0,	# Don't use 'next 25 entries' buttons
	'count'    => 25,	# How many entries should we offer at a time?
        'tdopts' => 'align=left', # Align the table rows to the left
	'nosearchname' => 1,	# No 'Search Papers' bit
	'useropts' => [],	# User options to use in 'list' menu
	   };

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";		# System that hosts the database
# $DBTYPE   = "";		# The type of database that we're working on
# $DATABASE = "";		# Name of the database we're connecting to
# $DBUSER   = "";		# Username to connect to the database
# $DBPASS   = "";		# Password to connect to the database

do '/home/webserver/dbaccess/user.pubdb';     # Populate DBUSER, DBPASS, etc

## This variable records how much debugging information you want in the
## HTML footers.  It works similarly to Unix permissions, by OR-ing the 
## appropriate options:
## 
##    	1	Print SQL queries
##   	2	Print CGI parameters
##      4	Print environment variables
##
## ie, '6' would print CGI and environment variables, and '5' would print 
## environment variables and SQL queries.  '0' will print nothing.

$DEBUG   = 0;					

## Modify this to change what default actions are available to manipulate
##  the available databases - choose from 'list', 'create', and 'search'

@ACTIONS = qw( list search );
				
## These are references to code that will output the headers, body, and 
## footers for the messages.  If you want to change these, you can either 
## modify the code (which is below) or create a new set of functions and 
## change the below code references appropriately.

$HTMLHEAD = \&tbhtml_head_internal;
$HTMLFOOT = \&tbhtml_foot_database;
$HTMLBODY = \&html_body; 

## Include the following in the TCB group header sidebars.

$ENV{'SIDEBAR'} = "<p><a href='/Group/InfoWeb/Publications/'>Internal<br />Publications<br />Pages</a></p>";

## Do we want to use a specific stylesheet?  This position is relative to
## wherever the script is being run.

$STYLESHEET = "stylesheet.css";

###############################################################################
### main() ####################################################################
###############################################################################

use CGI;
use DBIx::Frame::CGI;
use TCB::TeX2HTML;
use strict;
# $ENV{'PATH'} = "";

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

$0 =~ s%.*/%%g;		# Lose the annoying path information
my $cgi = new CGI || die "Couldn't open CGI";
$DB = $ROOTCLASS->connect( $DATABASE, $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
	or Error("Couldn't connect to $DBHOST: $DBI::errstr\n");
my $error = $DBI::errstr;	# Avoid a warning, otherwise unnecessary

$DB->set_list( 'Papers', [ 
    { '' => [\&html_listbib, '$$TBRef$$', '$$TBCode$$', 
                                          '$$Title$$', '$$Authors$$' ] }
                         ] );
$DB->set_html( 'Papers', \&html_search );

my $params = {};
foreach ($cgi->param) { $$params{$_} = $cgi->param($_); }

if (scalar @ACTIONS) { @DBIx::Frame::ACTIONS = @ACTIONS }

( print $cgi->header(), &$HTMLHEAD($TITLE, 
			-style => {-src=>$STYLESHEET}), "\n" ) && $HTML++;

if (lc $$params{'action'} eq 'list') {
  # First off, create the search based on $params
  my $hash = {};
  foreach (qw(Title Authors Journal Volume PubStatus CorrAuth AccountNum
              TBRef TBCode TechRpt)) {
    $$hash{$_} = "%$$params{$_}%" if $$params{$_};
  }
  my $start = $$params{"Year.Start"};
  my $end   = $$params{"Year.End"};
  my $first = $$params{"Number.First"};
  my $last  = $$params{"Number.Last"};
  
  my $grant = $$params{"Grant"};
  $$hash{'Grant1'} = [ "like '%$grant%' OR Grant2 like '%$grant%' OR Grant3 like '%$grant%'" ] if $grant;
  
  $$hash{'PubDate'} = [ $start ? ">= $start" : "", $end ? "<= $end" : ""];
  $$hash{'TBRef'}   = [ $first ? ">= $first" : "", $last ? "<= $last" : ""]; 
  my (@data);
  my ($counter1, $counter2, $counter3) = 0;
  foreach my $data ($DB->select('Papers', $hash )) {
    next unless ref $data;
    my $tbref = $$data{TBRef};  
    if (TCB::Publications::Papers->is_rejected($data)) {
      $tbref = "Rejected # "  . ++$counter1; $$data{TBRef} = $tbref;
    } elsif (TCB::Publications::Papers->is_submitted($data)) { 
      $tbref = "Submitted # " . ++$counter2; $$data{TBRef} = $tbref;
    } elsif ( !$tbref ) {
      $tbref = "Unknown # "   . ++$counter3; $$data{TBRef} = $tbref;
    } 
    push @data, $data;
  }
  print $DB->html_list_nosearch('Papers', $params, $OPTIONS, @data );
} elsif (lc $$params{'action'} eq 'print') {
  my $tbcode = $cgi->param('tbcode') || $cgi->param('code')
                                   || Error("Must supply TBCode");

  my %codes;
  foreach my $data ($DB->select('Papers', { 'TBCode' => $tbcode })) {
    $codes{$$data{TBCode}} = $data if ref $data;
  }
  Error("No results returned for $tbcode\n") unless (keys %codes);

foreach my $tbref (sort { $a <=> $b } keys %codes) {
  next unless $tbref;
  my $data = $codes{$tbref};

  # Print off local information
  my $bib = tex2html(TCB::Publications::Papers->getbib($tbcode));
  map { s/Damjanovi\\'c/Damjanovic/g } $bib;   # Special case for Ana
  print "<h2>$tbcode - Full Citation</h2>\n";
  print $bib ? "<p> <b>$bib</b> </p>\n" : "<p>No cite to print.</p>\n";

  print "<h2>Abstract</h2>\n";
  my $abstract = TCB::Publications::Papers->abstract($tbcode);
  print $abstract ? "<p> $abstract </p>\n" : "<p>No abstract available.</p>\n";

  my @fulltext = $DB->html_fulltext($tbcode, 1);

  print "<h2>Full Text</h2>\n";
  if (scalar @fulltext) { 
    print "<ul>\n";
    foreach (@fulltext) { print "<li> $_\n"; }
    print "</ul>\n";
  } else { print "<p>No full-text versions of this paper available.</p>" }

  print "<h2> Additional Information </h2>\n";
  print <<HTML;
<div class="basetable">
 <div class="row1">
  <span class="label">Corresponding Author</span>
  <span class="formw">@{[ $$data{CorrAuth} || "<i>None on record</i>" ]}</span>
 </div>
 <div class="row1">
  <span class="label">Authors</span>
  <span class="formw">@{[ $$data{Authors} || "<i>None on record</i>" ]}</span>
 </div>
 <div class="row1">
  <span class="label">Title</span>
  <span class="formw">@{[ $$data{Title} || "<i>None on record</i>" ]}</span>
 </div>

 <h3 class="tablehead">Journal Information</h3>
 
 <div class="row2">
  <span class="label">Journal Name</span> 
  <span class="formw">@{[ $$data{Journal} || "<i>None on record</i>" ]}</span>
  <span class="label">Date</span> 
  <span class="formw">@{[ $$data{PubDate} || "<i>None on record</i>" ]}</span>
 </div>

 <div class="row3">
  <span class="label">Vol #</span> 
  <span class="formw">@{[ $$data{JournalVolume} || "<i>None on record</i>" ]}</span>
  <span class="label">Man #</span> 
  <span class="formw">@{[ $$data{JournalManNum} || "<i>None on record</i>" ]}</span>
  <span class="label">Pages</span> 
  <span class="formw">@{[ $$data{Pages} || "<i>None on record</i>" ]}</span>
 </div>

 <h3 class="tablehead">Book Information</h3>

 <div class="row2">
  <span class="label">Title</span> 
  <span class="formw">@{[ $$data{BookTitle} || "<i>None on record</i>" ]}</span>
  <span class="label">Year</span> 
  <span class="formw">@{[ $$data{BookYear} || "<i>None on record</i>" ]}</span>
 </div>

 <div class="row2">
  <span class="label">Publshers</span> 
  <span class="formw">@{[ $$data{BookPublishers} || "<i>None on record</i>" ]}</span>
  <span class="label">Editors</span> 
  <span class="formw">@{[ $$data{BookEditors} || "<i>None on record</i>" ]}</span>
 </div>

<div>
  <div class="modbox">
    @{[ $DB->created_html( $$data{CreateDate} || "", 
                             $$data{ModifyDate} || "",
                             $$data{CreatedBy}  || "", 
                             $$data{ModifiedBy} || "") ]}
  </div>
  
  <div class="rowfloat">
   <br />
   <span class="label">Tech Rpt #</span>
   <span class="formw"> @{[ $$data{TechRpt} || "<i>None</i>" ]} </span>
   <br />
   <span class="label">TB Ref</span>
   <span class="formw"> @{[ $$data{TBRef} || "<i>None</i>" ]} </span>
  </div>
 </div>

</div>
HTML
  }

} else { print $DB->make_html( 'Papers', 'search', $params, $OPTIONS ) }

# print &$HTMLBODY($DB, $params) || Error("There was an error in this script");
print &$HTMLFOOT($DEBUG);
exit(0);

sub html_listbib {
  my ($DB, $tbref, $tbcode, $origtitle, $origauthor) = @_;
  return "" unless $tbcode; 
  $tbref ||= "Unknown";

  my @return = "";

  # Split out the title, so we don't print it twice (this algorithm was
  # from the old publications database; I don't really understand it, or
  # at least I haven't looked at it enough to really get it.)
  my ($author, $title, @rest) = split(/\\newblock/,
                             TCB::Publications::Papers->getbib($tbcode) || "" );
  
  $title ||= "";
  $title =~ s/^\s+|\s+$//g;
  $title ||= $origtitle;  # $author ||= $origauthor;
  $title = tex2html($title || "");  $title =~ s/^\s+|\s+$//g; # Trim whitespace
  push @return, "$tbref. <a href='$0?action=print&tbcode=$tbcode'>$title</a>\n";
  push @return, tex2html("$author @rest") if $author;

  map { s/Damjanovi\\'c/Damjanovic/g } @return;   # Special case for Ana
  wantarray ? @return : join("\n", @return);
}

sub html_search {
  my ($self, $entry, $type, $options, @rest) = @_;
  my @status = sort @TCB::Publications::Papers::PUBSTATUS;
  push @status, '';

  my @return = <<HTML;
  
<div class="basetable">
 <h3 class="tablehead"> Search by Keyword </h3>
 <h3 class="tablehead"> (queries are logically ANDed) </h3>
 
 <div class="row1">
  <span class="label">Title</span>
  <span class="formw">
   @{[ $cgi->textfield('Title', $$entry{Title} || "", 70, 1024) ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Author</span>
  <span class="formw">
   @{[ $cgi->textfield('Authors', $$entry{Authors} || "", 70, 1024) ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Corresponding Author</span>
  <span class="formw">
   @{[ $cgi->textfield('CorrAuth', $$entry{'CorrAuth'} || "", 70, 255) ]}
  </span>
 </div>

 <div class="row2">
  <span class="label">Volume</span>
  <span class="formw">
   @{[ $cgi->textfield('JournalVolume', $$entry{'JournalVolume'} || "", 8, 255) ]}
  </span>      
  <span class="label">Year</span>
  <span class="formw">
   @{[ $cgi->textfield('Year.Start', $$entry{'Year.Start'} || "", 5, 4) ]}
    - 
   @{[ $cgi->textfield('Year.End', $$entry{'Year.End'} || "", 5, 4) ]}
   <br /><i>must be 4-digit year!</i>
  </span>
 </div>

 <div class="row1">
  <span class="label">Reference Number</span>
  <span class="formw">
   @{[ $cgi->textfield('Number.First', $$entry{'Number.First'} || "", 5, 4) ]}
    - 
   @{[ $cgi->textfield('Number.Last', $$entry{'Number.Last'} || "", 5, 4) ]}
   (or just @{[ $cgi->textfield('Number', $$entry{'Number'} || "", 5, 4) ]})
  </span>
 </div>

 <div class="row2">
  <span class="label">TB Code</span> 
  <span class="formw">
   @{[ $cgi->textfield('TBCode', $$entry{TBCode} || "", 10, 10) ]}
  </span>
  <span class="label">TechRpt #</span> 
  <span class="formw">
   @{[ $cgi->textfield('TechRpt', $$entry{TechRpt} || "", 10, 10) ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Grant</span> 
  <span class="formw">
   @{[ $cgi->textfield('Grant', $$entry{Grant} || "", 40, 256) ]}
  </span>
 </div>

 <div class="row2">
  <span class="label">Account # </span>
  <span class="formw">
   @{[ $cgi->textfield('AccountNum', $$entry{AccountNum} || "", 10) ]}
  </span>
  <span class="label">Page Number</span>
  <span class="formw">
   @{[ $cgi->textfield('PageStart', $$entry{PageStart} || "", 5) ]}
    - 
   @{[ $cgi->textfield('PageEnd', $$entry{PageEnd} || "", 5) ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Publication Status</span>
  <span class="formw">
    @{[$cgi->popup_menu('PubStatus', \@status, $$entry{PubStatus} || "") ]}
  </span>
 </div>

 <div class="submitbar"> @{[ $cgi->submit(-name=>"Submit") ]} </div>
</div>

<h2> Common Searches </h2>
<table>
 <tr> 
  <td align=center> By Reference Number </td>
  <td align=center> By Time Period</td>
  <td align=center> By PI </td>
 </tr><tr>
  <td align=center>
   <a href="$0?action=list&Number.First=302">302- </a> <br>
   <a href="$0?action=list&Number.First=232&Number.Last=301">232 - 301</a> <br>
   <a href="$0?action=list&Number.First=183&Number.Last=231">183 - 231</a> <br>
   <a href="$0?action=list&Number.First=120&Number.Last=182">120 - 182</a> <br>
   <a href="$0?action=list&Number.First=61&Number.Last=119">61 - 119</a> <br>
   <a href="$0?action=list&Number.First=1&Number.Last=60">1 - 60</a> <br>
   </td>
  <td align=center> 
   <a href="$0?action=list&Year.Start=1997">1997 - present</a> <br>
   <a href="$0?action=list&Year.Start=1994&Year.End=1996">1994 - 1996</a> <br>
   <a href="$0?action=list&Year.Start=1990&Year.End=1993">1990 - 1993</a> <br>
   <a href="$0?action=list&Year.Start=1986&Year.End=1989">1986 - 1989</a> <br>
   <a href="$0?action=list&Year.End=1985">until 1985</a> <br> </td>
  <td align=center>
   <a href="$0?action=list&Authors=Schulten">Klaus Schulten</a> <br>
   <a href="$0?action=list&Authors=Kale">Laxmikant Kale</a> <br>
   <a href="$0?action=list&Authors=Skeel">Bob Skeel</a> <br>
   <a href="$0?action=list&Authors=Martinez">Todd Martinez</a> <br>
 </tr> 
</table>

HTML
  wantarray ? @return : join("\n", @return);
}

###############################################################################
### Subroutines ###############################################################
###############################################################################

## Error ( PROBLEM [, PROBLEM [...]] )
# Prints an error message based on PROBLEM and exits.

sub Error {
  print CGI->header(), &$HTMLHEAD("Error in '$0'", 
		-style => {-src=>$STYLESHEET}) unless $HTML;

  print "This script failed for the following reasons: <p>\n<ul>\n";
  foreach (@_) { next unless $_; print "<li>", canon($_), "<br>\n"; }
  print "</ul>\n";

  print &$HTMLFOOT($DEBUG);
  exit 0;
}

## canon ( ITEM )
# Returns a printable version of whatever it's passed.  Used by Error().

sub canon {
  my $item = shift;
  if    ( ref($item) eq "ARRAY" )   { join(' ', @$item) }
  elsif ( ref($item) eq "HASH" )    { join(' ', %$item) }
  elsif ( ref($item) eq "" )        { $item }
  else                              { $item }
}

## html_head ( TITLE [, OPTIONS] )
# Prints off a basic HTML header, with debugging information.  Extra
# options are passed through to start_html.

sub html_head { 
  my $title = shift || $TITLE || "";
  use CGI;   my $cgi = new CGI;
  $cgi->start_html( -title => $title, @_ );
}

## html_body ( DB, PARAMS [, OPTIONS] )
# Prints off the HTML body.
sub html_body {
  my ($DB, $params, $options) = @_;
  return "" unless ref $params;
  my @journals = sort $DB->select_fieldlist('Journals', 'ShortName');
  map { s/^\s+|\s+$//g } @journals;       # Get rid of excess whitespace
  unshift @journals, '';

  CGI->popup_menu('Journal', \@journals, "" )
}

## html_foot ( DEBUG [, OPTIONS] )
# Prints off a basic HTML footer, with debugging information.

sub html_foot { 
  my $debug = shift || $DEBUG;
  use CGI;   my $cgi = new CGI;
  my @return = debuginfo($debug);
  push @return, $cgi->end_html(@_);
  join("\n", @return, "");
}

## debuginfo ( LEVEL ) 
# Takes care of printing debugging information, as described above

sub debuginfo {
  my $debug = shift || 0;

  my @return;
  if ($debug) { 
    push @return, "<hr />", "<h2> Debugging Information </h2>";

    if ($debug & 1) {
      push @return, "SQL Queries: <p>\n<ul>";
      foreach ($DB->queries) { push @return, " <li>$_" }
      push @return, "</ul>";
    }

    if ($debug & 2) {
      push @return,  "Parameters: <p>\n<ul>\n";
      foreach ($cgi->param) { push @return,  " <li>$_: ", $cgi->param($_); }
      push @return,  "</ul>";
    }

    if ($debug & 4) {
      push @return,  "Environment Variables: <p>\n<ul>";
      foreach (sort keys %ENV) { push @return, " <li>$_: $ENV{$_}"; }
      push @return,  "</ul>";
    }
    push @return, "<hr />";
  }

  wantarray ? @return : join("\n", @return);
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.0a 	Thu Jul 12 14:06:12 CDT 2001
### Release candidate.  Internal documentation written, it seems modular.
# v1.1 		Fri Apr  5 09:24:12 CST 2002
### Separated out html_body() as well as html_head() and html_foot().  This
### should let everything be modular except the sub-functions and the
### configuration.
# v1.2 		Fri Oct 11 10:29:52 CDT 2002
### Fixed a bug in Error() - didn't print the CGI->header() in there before.
# v1.3		Tue Oct 21 13:35:53 CDT 2003 
### Renamed DBI::Frame to DBIx::Frame, so updated everything accordingly.
# v1.4		Tue May 11 13:00:14 CDT 2004 
### Cleaned up with TCB::System.
# v1.5		Mon May 17 14:03:24 CDT 2004 
### Forked from DBIx::Frame.  Now a part of TCB::Publications.  Specific
### documentation added.
# v1.5.1	Thu May 20 14:15:59 CDT 2004 
### Swapped some lines in html_listbib() to get tex2html() run on all
### titles.
