$VERSION = "1.00";
package TCB::TeX2HTML;
# -*- Perl -*- 		Fri May 14 13:58:17 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.  
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################
our $VERSION = "1.00";

=head1 NAME

TCB::TeX2HTML - a TeX to HTML converter

=head1 SYNOPSIS

  use TCB::TeX2HTML;
  my $string = 'to $3j$- and $6j$-Coefficients';
  my $converted = tex2html($string);
  print $converted;

=head1 DESCRIPTION

TCB::TeX2HTML offers the function tex2html(), which can be used to convert
TeX into something usable on the web.  It is done by piping the text
through 'tth', a free TeX->HTML converter (defined in the variable
$TB::TeX2HTML::CONVERT if you wish to redefine it).

=cut

###############################################################################
### User Variables ############################################################
###############################################################################
use vars qw( $CONVERT @ISA @EXPORT @EXPORT_OK $VERSION );

## What program do we run to do the conversion?

$CONVERT   = "/usr/local/bin/tth -r";

###############################################################################
### main() ####################################################################
###############################################################################

use strict;
use FileHandle;
use IPC::Open3;
use Exporter;
use warnings;

@ISA       = qw( Exporter );
@EXPORT    = qw( &tex2html );
@EXPORT_OK = qw( &filter );

###############################################################################
### Subroutines ###############################################################
###############################################################################

=head2 Functions

=over 4

=item tex2html ( TEXT ) 

Converts every line of TEXT (each of which should be a string) from TeX
to HTML, as detailed in this module.  Returns an array of strings or, if
invoked as a scalar, a single string with lines separated by newlines.
Invokes filter($CONVERT, TEXT).  Exported by default.

=cut

sub tex2html {
  my $state = $|; $| = 1;
  my @return = filter($CONVERT, @_);
  $| = $state;
  wantarray ? @return : join("\n", @return);
}

=item filter ( PROGRAM, TEXT )

Filters TEXT through the given PROGRAM.  Not exported by default, but may
be imported if you wish.

=cut

sub filter {
  my $program = shift;
  my $stdin  = new FileHandle;  my $stdout = new FileHandle;
  my $stderr = new FileHandle;

  my $pid = eval { open3 ( $stdin, $stdout, $stderr, $program ) };
  if ($@) { warn "Execution of $program failed: $@\n"; return undef; }

  my @lines = grep { defined } @_;  
  # map { $_ if defined $_ } @lines;
  foreach (@_) { print $stdin "$_\n" if defined $_ }
  close $stdin;

  my @output = <$stdout>;
  close $stdout;  close $stderr;  waitpid($pid, 0);     # Clean up
  wantarray ? @output : join("\n", @output);
}

=back 

=cut

1;

=head1 NOTES

It would be a lot better to write a program that actually does the
conversion, but for now this works.  If anybody feels ambitious in the
future...

=head1 REQUIREMENTS

Perl 5.6.0 or better, /usr/local/bin/tth (TeX->HTML converter)

=head1 SEE ALSO

B<http://hutchinson.belmont.ma.us/tth/>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.1		Wed Oct  9 10:23:52 CDT 2002
### First real vesion that's actually a module and such.  Much nicer.  
# v1.00		Fri May 14 13:56:45 CDT 2004 
### Cleaned up and ready for distribution.  Now called TCB::TeX2HTML.
