$VERSION = "1.00";
package TCB::Publications::Journals;
our $VERSION = "1.00";

# -*- Perl -*- 		Fri May 14 14:55:21 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME

TCB::Publications::Journals - journals of TCB Publications

=head1 SYNOPSIS

  use TCB::Publications::Journals;

See TCB::Publications for more information.

=head1 DESCRIPTION

The 'Journals' table is supposedly used to translate journal names from 
short to long; however, it hasn't been used for that in a long time.
Instead, its main purpose is to store a convenient list of journal names
for Jo's use, and to allow her to add more when necessary.

This table contains the following fields:

 Internal Information
  ID            Unique numeric ID - auto-generated (INT)

 Basic Information (TINYTEXT fields, unless noted)
  ShortName	The short name of the journal
  Name		The full name of the journal (NOT USED)

Key fields:     ShortName

List items:     ShortName

Required:       Same as Key fields.

Default order:  ShortName

Admin Fields:   None

The 'Papers' table depends on this table.

Doesn't depend on any other table.

=head1 USAGE

=cut

###############################################################################
### Initialization ############################################################
###############################################################################
use vars qw( @ISA $FIELDS $KEYS $NAME $LIST $REQUIRED $ADMIN $ORDER );
use strict;
use warnings;
use CGI;
use TCB::Publications;

push @ISA, qw( TCB::Publications );

###############################################################################
### Database Variables ########################################################
###############################################################################
$NAME = "Journals";
$FIELDS = {
  'ID'          =>  'INT NOT NULL PRIMARY KEY AUTO_INCREMENT',
  'ShortName'   =>  'TINYTEXT',    'Name'       =>  'TINYTEXT'
          };
$KEYS  = [ 'ShortName' ];
$LIST  = [ 'ShortName' ];
$REQUIRED = $KEYS;
$ADMIN = [ ];
$ORDER = [ 'ShortName' ];

###############################################################################
##### Functions ###############################################################
###############################################################################

=head2 Internal Functions

=over 4

=item html ( ENTRY, TYPE, OPTIONS )

Prints the HTML version of the table.  Heavily customized for the TCB
environment, but then again so is the whole program.                            

=cut

sub html {
  my ($self, $entry, $type, $options, @rest) = @_;
  my $cgi = new CGI;  $entry ||= {};

  my @return = <<HTML;
<div class="basetable">
 <div class="row1">
  <span class="label">Short Name</span>
   @{[ $cgi->textfield('ShortName', $$entry{ShortName} || "", 40, 1024) ]}
  </span>
 </div>

 <div class="submitbar"> @{[ $cgi->submit(-name=>"Submit") ]} </div>

</div>

HTML
  wantarray ? @return : join("\n", @return);
}

=item text ( )

Not currently populated.

=cut

sub text { }

=back

=cut

###############################################################################
##### main() ##################################################################
###############################################################################

use strict;
use TCB::Publications qw( );
unshift @ISA, "TCB::Publications";

TCB::Publications->table_add($NAME, $FIELDS, $KEYS, $LIST, $ORDER, $ADMIN, 
                        $REQUIRED, \&html, \&text);

=head1 NOTES

=head1 TODO

Start working on intellectual property issues for these papers.

=head1 REQUIREMENTS

Perl 5.6.1 or better, DBIx::Frame, TCB::Publications.

=head1 SEE ALSO

B<TCB::Publications>, B<TCB::Publications::Papers>, B<DBIx::Frame>,
B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2          Tue Oct  8 17:10:40 CDT 2002
### First version using a real version of DBI::Frame.  Documented as well.
### No actual changes were made to the code yet, though.
# v0.3		Thu Nov 14 11:09:10 CST 2002
### Added 'Restricted' field to this table.  Heh.  'ALTER TABLE'.  Neat.
# v1.00		Fri May 14 15:00:27 CDT 2004 
### Ready for DBIx::Frame and TCB::Publications.
