$VERSION = "0.99";
package TCB::Publications;
our $VERSION = "0.99";

# -*- Perl -*- 		Fri May 14 13:28:54 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.  All rights reserved.
# Distribution terms are below. Copyright 2000-2004, Tim Skirvin and UIUC 
# Board of Trustees.
###############################################################################

=head1 NAME

TCB::Publications - the TCB Publications Database

=head1 SYNOPSIS

  use TCB::Publications;
  my $DB = TCB::Publications->connect( $DATABASE, $DBUSER, $DBPASS, 
						  $DBHOST, $DBTYPE )
        or die("Couldn't connect to $DBHOST: $DBI::errstr\n");

See below for how to actually use this object.

=head1 DESCRIPTION

TCB::Publications is a DBIx::Frame object used to track publications
within the TCB Group and share this information with the outside world.
It consists of a series of public CGI scripts that load this information
from a central database, several more scripts that are used internally to
track the information, and some perl modules that tie it all together.

This base class is used to load the table definitions and basic functions
for the database.  

Specific tables offered by this class:

=over 4

=item TCB::Publications::Files - file locations for fulltext copies of papers

=item TCB::Publications::Journals - journals the papers are published in

=item TCB::Publications::Papers - all information about the papers

=back

See each table's documentation for more information.

Additional functions are offered in B<TCB::Publications::Functions>.

=cut

use strict;
use vars qw(@ISA @PROBS @MODULES $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG );
use DBIx::Frame;
use Exporter;
use warnings;

###############################################################################
### USER VARIABLES ############################################################
###############################################################################
@MODULES  = qw( DBIx::Frame Exporter TCB::Publications::Files 
		TCB::Publications::Journals TCB::Publications::Papers 
          	TCB::Publications::Functions );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";                        # Default web server
$DATABASE = "Publications";
$DBTYPE   = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;
###############################################################################

###############################################################################
### main() ####################################################################
###############################################################################
foreach ( @MODULES ) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if scalar @PROBS;

# Initialize DBI::Frame (this has already been done a few times, but this
#   allows us to have a definite known state to finish with)
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

These tables were originally designed for msql by Charlie Brown (no
current email address on record) in approximately 1999.  They were
converted to MySQL by Tim Skirvin <tskirvin@ks.uiuc.edu> in 2000.  

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::Publications::Papers>,
B<TCB::Publications::Journals>, B<TCB::Publications::Functions>,
B<TCB::Publications::Files>

B<abstract.cgi>, B<journal.cgi>, B<list.cgi>, B<pdf.cgi>, B<topic.cgi>,
B<paper_internal.cgi>, B<paper_print.cgi>, B<paper_admin.cgi>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-publications/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2		Tue Oct  8 15:26:56 CDT 2002
### First version to use real DBI::Frame code.  Getting ready for some major
### structural changes as well.  
# v0.21		Thu Nov 14 12:36:58 CST 2002
### Uses updated Files.pm and Publications.pm.
# v0.99		Fri May 14 14:12:37 CDT 2004 
### Updating for DBIx::Frame, and eventual release.
