#!/usr/local/bin/perl -w
# -*- Perl -*- Wed Apr  3 13:28:31 CST 2002
###############################################################################
# This script mails 
###############################################################################
use vars qw( $DBHOST $DBTYPE $DATABASE $DBUSER $DBPASS $DEBUG $CLASS $DB $HTML 
             $OPTIONS $TITLE @ACTIONS $HTMLHEAD $HTMLFOOT $VERSION $TYPE 
	     $FROM $REPLYTO $CC );
$VERSION = "1.0a";

###############################################################################
### CONFIGURATION + PRIVATE DATA ##############################################
###############################################################################

$FROM    = 'sysadmin@ks.uiuc.edu (System Administration Team)';
$REPLYTO = 'sysadmin@ks.uiuc.edu';
$CC      = 'contact@ks.uiuc.edu';

$TYPE = "test";		# Set to 'sendmail' to actually send mail
# TYPE = "sendmail";

## Load shared configurations and/or private data using 'do' commands, as
## seen below.  Note that several 'do's can be run if necessary.  

# do '/FULL/PATH/TO/CODE/TO/RUN';	

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Loan";			# Database class

## Modify and uncomment this to use user code instead of just system-wide 
## modules.  Note that this path must be set up as a standard Perl tree;
## I'd personally recommend just installing things system-wide unless you're
## a developer.

# use lib '/FULL/PATH/TO/PERL';

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";		# System that hosts the database
# $DBTYPE   = "";		# The type of database that we're working on
# $DATABASE = "";		# Name of the database we're connecting to
# $DBUSER   = "";		# Username to connect to the database
# $DBPASS   = "";		# Password to connect to the database

do '/home/webserver/dbaccess/user.sysguest';   	# Populate DBUSER, DBPASS, etc

## This variable records how much debugging information you want in the
## HTML footers.  It works similarly to Unix permissions, by OR-ing the 
## appropriate options:
## 
##    	1	Print SQL queries
##   	2	Print CGI parameters
##      4	Print environment variables
##
## ie, '6' would print CGI and environment variables, and '5' would print 
## environment variables and SQL queries.  '0' will print nothing.

$DEBUG   = 0;					

###############################################################################
### main() ####################################################################
###############################################################################

use DBIx::Frame;
use Mail::Mailer;
use strict;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

$0 =~ s%.*/%%g;		# Lose the annoying path information
$DB = $CLASS->connect( $DATABASE, $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
	or die "Couldn't connect to $DBHOST: $DBI::errstr\n";
my $error = $DBI::errstr;	# Avoid a warning, otherwise unnecessary

my %users;
foreach my $entry ( $DB->select('Loan', { } ) ) {
  next if ($$entry{LoanEnd} && $$entry{LoanEnd} ne "0000-00-00");
  my $user = $$entry{'BorrowerName'};  next unless $user;
  $users{$user} ||= [];
  push @{$users{$user}}, description($entry);
}

my $time = scalar localtime;
foreach my $user (sort keys %users) {
  my @items = @{$users{$user}};
  my $headers = {
    'To'       => $user,
    'Subject'  => "Equipment on loan - $time ($user)",
    'From' => $FROM, 'Reply-To' => $REPLYTO, 'Cc' => $CC
  };
  my $mailer = new Mail::Mailer($TYPE);
  $mailer->open($headers);
  print $mailer <<EOL;
You currently have the following items checked out from the Theoretical 
and Computational Biophysics Group (www.ks.uiuc.edu):

@{[ join("\n", @items) ]}

Note that this is not a request to return the items, only a regular
reminder.  If you wish to return any of these items, please reply to this
mail or contact us at 217/244-1855.  Thank you.

			- TCBG System Administration Team

EOL
  
}

exit(0);

###############################################################################
### Subroutines ###############################################################
###############################################################################

sub description {
  my $entry = shift || return "";
  sprintf("%-15s", $$entry{Description});
}

## canon ( ITEM )
# Returns a printable version of whatever it's passed.  Used by Error().

sub canon {
  my $item = shift;
  if    ( ref($item) eq "ARRAY" )   { join(' ', @$item) }
  elsif ( ref($item) eq "HASH" )    { join(' ', %$item) }
  elsif ( ref($item) eq "" )        { $item }
  else                              { $item }
}

## debuginfo ( LEVEL ) 
# Takes care of printing debugging information, as described above

sub debuginfo {
  my $debug = shift || 0;

  my @return;

  if ($debug & 1) {
    push @return, "SQL Queries: ";
    foreach ($DB->queries) { push @return, " o $_" }
  }

  if ($debug & 4) {
    push @return,  "Environment Variables: ";
    foreach (sort keys %ENV) { push @return, " o $_: $ENV{$_}"; }
  }

  wantarray ? @return : join("\n", @return);
}

###############################################################################
### License Information #######################################################
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2002, Tim Skirvin and UIUC Board of Trustees.
# This program is part of the TB::Loan package, available at
#   http://www.ks.uiuc.edu/Development/MDTools/dbiframe/
# License terms are on this web page, or included in the main package.

###############################################################################
### Version History ###########################################################
###############################################################################
### v0.91	Wed Apr  3 13:30:18 CST 2002
# Documented and ready for distribution.
# Release candidate.  Internal documentation written, it seems modular.
