#!/usr/local/bin/perl
use vars qw( $DB $GROUP $DEBUG $DATABASE $DBUSER $DBPASS $DBHOST $DBTYPE 
	     $VERSION $URL $CLASS $ROOTCLASS $FROM $REPLYTO $CC $TYPE );
$VERSION = "1.2";

=head1 NAME

library_remind.pl - Send out periodic reminders about book checkouts

=head1 SYNOPSIS

In your crontab

  0 0 1 6,12 * PATH/library_remind.pl
  
=head1 DESCRIPTION

library_remind.pl is a script to mail users, explaining that they
currently have books checked out from the library.  It's not much more
complicated than that.

=head1 NOTES

This script is set up to, by default, not actually send any email.  You'll
have to customize it (change 'test' to 'sendmail') to actually send the
mail.

Users don't like being pestered often.  Probably once every six months is
enough; and definitely make sure you don't leave full mail sending on
during testing!

=head1 REQUIREMENTS

B<TCB::Library>, B<Mail::Mailer>

=head1 SEE ALSO

B<TCB::Library>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### User Configuration ########################################################
###############################################################################

## Configuration for Mail::Mailer - set to 'sendmail' to actually send the
## mail, 'test' to just test.
$TYPE = "test";         
# TYPE = "sendmail";

## From, Reply-To, and Cc: headers for outgoing mails.

$FROM    = 'sysadmin@ks.uiuc.edu (System Administration Team)';
$REPLYTO = 'sysadmin@ks.uiuc.edu';
$CC      = 'contact@ks.uiuc.edu';

## This is the perl class that you will be using in this script.  

$CLASS   = "TCB::Library";                      # Database class

## This is the root class of the above class.  Essentially a hack to let
## there be multiple modules using the same database.

$ROOTCLASS = "TCB::Library";               # Class of the database class

## Database Information
## You may want to set these with a common config file, using 'do FILE'.
## Also, defaults may already be set within the class; only set these if
## you want to override the defaults.

# $DBHOST   = "";               # System that hosts the database
# $DBTYPE   = "";               # The type of database that we're working on
# $DATABASE = "";               # Name of the database we're connecting to
# $DBUSER   = "";               # Username to connect to the database
# $DBPASS   = "";               # Password to connect to the database

do '/home/webserver/dbaccess/user.libguest'; # Populate DBUSER, DBPASS, etc

## What URL should we point users at?

$URL = "http://www.ks.uiuc.edu/Group/InfoWeb/Library/";

###############################################################################
### main() ####################################################################
###############################################################################

use strict;
use Mail::Mailer;

# Load the appropriate class module
{ local $@; eval "use $CLASS";  die "$@\n" if $@; }

$DB = $ROOTCLASS->connect( "InfoWeb", $DBUSER, $DBPASS, $DBHOST, $DBTYPE )
                   or die "Couldn't connect to database: " . DBI->errstr;

my (%users, %books);

foreach my $entry ( $DB->select('Library', { } ) ) {
  my $user = $$entry{name};	my $code = uc $$entry{code};  
  # $users{$user} = $users{$user} ? join(', ', $users{$user}, $code) : $code; 
  # $books{$code} = $$entry{borrowdate};
  $users{$user} ||= [];
  push @{$users{$user}}, description($entry);
}

my $time = scalar localtime;
foreach my $user (sort keys %users) {
  my @items = @{$users{$user}};
  my @books = split(',', $users{$user});  next unless scalar @books;

  my $headers = {
    'To'       => $user,
    'Subject'  => "Books checked out - $time ($user)",
    'From' => $FROM, 'Reply-To' => $REPLYTO, 'Cc' => $CC
  };

  my $mailer = new Mail::Mailer($TYPE);
  $mailer->open($headers);
  print $mailer <<EOL;
You currently have the following books checked out from the Theoretical 
and Computational Biophysics Group (www.ks.uiuc.edu):

@{[ join("\n", @items) ]}
Note that this is not a request to return the items, only a regular
reminder.  If you wish to return any of these items, please reply to this
mail or contact us at 217/244-1855.  Thank you.

                        - TCBG System Administration Team
EOL
  # $mailer->close;
}

sub description {
  my $entry = shift || return "";
  return "" unless ($entry && ref $entry);
  my $code = $$entry{code} || return "";
  my ($title, $author, $date, @return);
  $date  = $$entry{borrowdate} || "??";
  foreach my $book ( $DB->select('Book', { 'code' => $code }) ) {
    $title = $$book{title} || "";  $author = $$book{author} || "";
  }
  push @return, ( uc $code ) . " (checked out on $date)";
  push @return, " Title:  $title\n Author: $author";
  return join("\n", @return, '');
}

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.1          Tue Oct 21 15:40:16 CDT 2003 
### Wrapping this up a bit pretty, for public release.  I'm not really
### sure how well it works, to be honest.
# v1.2		Wed May 19 15:13:03 CDT 2004 
### Rewritten to match how we do things with TCB::System.
