$VERSION = "1.1";
package TCB::Library;
our $VERSION = "1.1";

# -*- Perl -*-		Wed May 19 14:06:22 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.  All rights reserved.
# Distribution terms are below. Copyright 2000-2004, Tim Skirvin and UIUC 
# Board of Trustees.
###############################################################################

=head1 NAME

TCB::Library - a basic library, written for DBIx::Frame

=head1 SYNOPSIS

  use TCB::Library;
  my $DB = TCB::Library->connect( $DATABASE, $DBUSER, $DBPASS, 
                                                  $DBHOST, $DBTYPE )
        or die("Couldn't connect to $DBHOST: $DBI::errstr\n");

See the included CGI scripts to see how it works.

=head1 DESCRIPTION

TCB::Library is a DBIx::Frame object written to keep track of library
books at the Theoretical and Computational Biophysics Group at UIUC.  It
provides a web interface for adding books to the library, for users to
check out and return them, and for reminder messages to be sent out
periodically listing what books are checked out.  This is actually a
fairly basic function of research groups, but doesn't have a standard
software package.

This base class is used to load table definitions and basic functions for
the database.  

Specific tables offered by this class:

=over 4

=item TCB::Library::Book - individual books
 
=item TCB::Library::Library - checkout information

=back

=cut

use strict;
use vars qw(@ISA @PROBS @MODULES $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG );
use DBIx::Frame;
use Exporter;
use warnings;

###############################################################################
### User Variables ############################################################
###############################################################################
@MODULES  = qw( DBIx::Frame Exporter TCB::Library::Functions TCB::Library::Book
	        TCB::Library::Library );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";	  
$DATABASE = "InfoWeb";
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;

###############################################################################
### main () ###################################################################
###############################################################################
# Load the necessary modules from @MODULES
foreach (@MODULES) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);

1;

=head1 NOTES

This pretty much works, but it's not the most portable thing in the world.
Major limitations: all users are assumed to be local users on the system
in question, the database design points towards our own local setup, and
even where concessions for reality have been given (multiple copies of
books, etc), these were instituted as hacks and not properly designed
around.  So all in all, if you want to use this package, you either a)
have to focus your library and general system design around our code or b)
use this as a starting point and hack it into something worthwhile for you.

The underlying InfoWeb database was originally designed before my time; I
don't know who actually did the work, but I suspect it was Charles Brown,
my predecessor.  I don't have an email address for him anymore.

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>.

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::Library::Book>, B<TCB::Library::Library>,
B<TCB::Library::Functions>

=head1 TODO

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-library/license.html>
for details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2		Mon Oct 13 13:42:41 CDT 2003 
### Setting up for real DBI::Frame.
# v0.9		Tue Oct 21 13:41:00 CDT 2003 
### Getting ready for release; renamed to TCB::Library from TCB::InfoWeb;
### now using DBIx::Frame.
# v1.0 	   	Tue Oct 21 16:05:14 CDT 2003 
### Initial public release.
# v1.1		Wed May 19 14:14:08 CDT 2004 
### Updating for DBIx::Frame, and eventual release.
