$VERSION = "1.00";
package TCB::Help;
our $VERSION = "1.00";

# -*- Perl -*-		Thu May 13 16:27:44 CDT 2004
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME

TCB::Help - a basic help database, written for DBIx::Frame

=head1 SYNOPSIS

  use TCB::Help;

See the included CGI scripts to see how it works.

=head1 DESCRIPTION

TCB::Help is a DBIx::Frame object written to keep track of technical help
members of the TCB Group have offered to other groups or institutions. 

Specific tables:

=over 4

=item TCB::System::Help - lists of offered help

=back

See each table's documentation for more information.

=cut

use strict;
use vars qw( @MODS $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG @ISA @PROBS );

### USER VARIABLES ############################################################
@MODS     = qw( DBIx::Frame Exporter TCB::System::Help );
@ISA      = qw( DBIx::Frame Exporter TCB::System );
$SERVER   = "db.ks.uiuc.edu";	  
$DATABASE = "System";
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;
###############################################################################

###############################################################################
### main () ###################################################################
###############################################################################
# Load the necessary modules from @MODS
foreach (@MODS) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

This has been under-utilized, but is still fairly handy.  

The database was designed by Tim Skirvin.

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>, B<TCB::System>

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::System>, B<TCB::Help>

=head1 TODO

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-help>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-help/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2		Mon Oct 13 13:42:41 CDT 2003 
### Setting up for real DBI::Frame.
# v0.95		Mon May 10 16:48:34 CDT 2004 
### Getting ready to use DBIx::Frame instead of DBI::Frame; this is a good
### excuse to comment everything and just generally make it all work.
### Comments are still based on old TCB::Library code, however.
# v1.00         Thu May 13 16:27:44 CDT 2004 
### Packaging up and distributing.
