use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {};  my $man3page = {};  my $scripts = [];  my $man1page = {};
foreach my $module ( qw( TCB::Backup ) ) { 
  my $file = $module;
     $file =~ s/::/\//g;  
     $file =~ s/$/.pm/;
  my $libdir = join('/', '$(INST_LIBDIR)', $file);
  my $man3 = join('/', '$(INST_MAN3DIR)', "$module.3");
  $$modules{$file} = $libdir; $$man3page{$file} = $man3;
}

foreach ( qw( ufsdump.config tardump.config ) ) {
  my $file = "manpage/$_.pod";
  my $man3 = join('/', '$(INST_MAN3DIR)', "$_.3");
  $$man3page{$file} = $man3;
}

foreach ( qw( dailybackup gtarbackup ) ) {
  my $file = "manpage/$_.pod";
  my $man1 = join('/', '$(INST_MAN1DIR)', "$_.1");
  $$man1page{$file} = $man1;
}


foreach ( qw(snapshot.0 snapshot.1 snapshot.daily snapshot.gtar ) ) { 
  my $file = "scripts/$_";
  my $man1 = join('/', '$(INST_MAN1DIR)', "$_.1");
  push @{$scripts}, $file;  $$man1page{$file} = $man1;
}

foreach ( qw( dailybackup fssnap gtarbackup ) ) { 
  my $file = "scripts/$_";
  push @{$scripts}, $file;  
}

WriteMakefile(
    'NAME'         => 'TCB-Backup',
    'DISTNAME'     => 'TCB-Backup',
    'VERSION_FROM' => 'Version.pm', # finds $VERSION
    'MAN1PODS'     => $man1page, 
    'MAN3PODS'     => $man3page, 
    'EXE_FILES'    => $scripts, 
    'PM'           => $modules,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
);
