#!/usr/local/bin/perl
# New user creation script
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>, Wed Oct 10 11:02:32 CDT 2001
# Last Updated: Tue Feb 18 10:39:41 CST 2003 

our $VERSION = "1.1";

use strict;
use Mail::Mailer;
use Sys::Hostname;
use lib '/home/tskirvin/dev/internal/tcb-adduser';
use TCB::AddUser qw( prompt );
use Getopt::Std;

use vars qw( $DEBUG $TEST @YPSERVER $opt_d $opt_t $opt_h $opt_v);
getopts('thvd');

@YPSERVER = qw( taipei edmonton );

### Initial Configuration
$0 =~ s%.*/%%;
Usage()   if $opt_h;
die "$0 v$VERSION (TCB::AddUser v$TCB::AddUser::VERSION)\n" if $opt_v ;

$DEBUG = $opt_d || 1;
$TEST  = $opt_t || 0;

if ($TEST)  { $TCB::AddUser::TEST  = 1 }
if ($DEBUG) { $TCB::AddUser::DEBUG = 1 }

### Make sure we're logged into taipei as root, unless we're just testing
my $hostname = hostname;  $hostname =~ s/\..*$//;
if (!$TEST) {
  my $ypserver = 0;
  foreach (@YPSERVER) { $ypserver++ if $_ eq $hostname }
  die "$0 must be run on a YP server (", join(", ", @YPSERVER), ")\n" 
							unless $ypserver;
  unless ($< eq 0) { die "$0 must be run as root\n"; }
} else {
  warn "Normally you have to run as root on a YP server, but we're testing.\n";
}

### Gather user information from the user and Gila/Tim
print "The following information will be provided from Tim/Emad.\n";
my ($addedby,$username,$uid,$group,$gid,$partition,$mailgroups,$passwords)
 	= TCB::AddUser->prompt_admininfo;

print "\nThe following information will be provided by the user.\n";
my ($realname, $address, $phone, $homedept, $position, $boss) 
	= TCB::AddUser->prompt_userinfo;

### Create password entry
print "\nCreating password entry\n";
TCB::AddUser->add_yppasswd($username, $uid, $gid, $realname, "/home/$username");
TCB::AddUser->add_hometable($username, $partition);
TCB::AddUser->push_yptables;

### Create/populate home directory
print "\nCreating and populating home directory\n";
TCB::AddUser->create_homedir($username, $partition) || 
				print "Couldn't create home directory\n";
TCB::AddUser->populate_homedir($username, $partition) || 
				print "Couldn't populate home directory\n";

### Set up a basic web page, if we're in the right group
if ($group eq 'tbres' || $group eq 'tbadm') {
  print "Setting up web page template\n";
  TCB::AddUser->create_webpage($partition, $username, $realname) ||
				print "Couldn't create homepage\n";
} elsif ($group eq 'tbguest') { 
  print "Setting up a .forward file\n";
  my $address = prompt('Regular email address');
  TCB::AddUser->create_forward($partition, $username, $address) ||
				print "Couldn't create .forward file: $!\n";
}

### Set passwords - YP, Samba, Web
print "\nThe user will now enter his/her password information.\n";
my ($yppasswd, $smbpasswd, $htpasswd) = TCB::AddUser->get_passwords(
	$$passwords{'System'} || $$passwords{'Samba'}, $$passwords{'Web'});
($htpasswd  && TCB::AddUser->set_htpasswd($username, $htpasswd))
	or warn "Web password not set\n";
($smbpasswd && TCB::AddUser->set_smbpasswd($username, $smbpasswd))
	or warn "SMB password not set\n";
($yppasswd  && TCB::AddUser->set_yppasswd($username, $yppasswd))
	or warn "YP password not set\n";

### Set mail aliases
print "\nSetting mail aliases\n";
push @{$mailgroups}, "g_users";
TCB::AddUser->add_mailalias($username, @{$mailgroups});

# Choose our mailer type, based on whether we're testing or not.
my $mailer = $TEST ? new Mail::Mailer 'test'  
		   : new Mail::Mailer 'sendmail';
		   
### Send email to newuser@ks.uiuc.edu
print "\nSending letter to newuser\@ks.uiuc.edu with user information\n";
$mailer->open( { 
	'Subject' => "new user $username added", 
	'To'      => 'newuser@ks.uiuc.edu',	
	'From'    => 'New user script <newuser@ks.uiuc.edu>',
	'Reply-To' => 'sysadmin@ks.uiuc.edu'
	       } );
print $mailer "Name:		$realname\n";
print $mailer "Address:\t", join("\n		", @{$address}), "\n";
print $mailer "Phone: 		$phone\n";
print $mailer "E-Mail:		$username\@ks.uiuc.edu\n";
print $mailer "Home Dept: 	$homedept\n";
print $mailer "Position:    	$position\n";
print $mailer "Group:		$group\n";
print $mailer "Supervisor:	$boss\n";
print $mailer "User Added By: 	$addedby\n";
print $mailer "Date: 		", scalar localtime, "\n";
$mailer->close;

### Send email to the new user, containing the info in <DATA> (which is
### appended to this script)
print "\nSending letter to new user\n";
$mailer->open( { 
	'From'	  => 	'sysadmin@ks.uiuc.edu (System Administrator List)',
	'Subject' => 	'Welcome to the Theoretical Biophysics Group',
	'Reply-To' => 	'sysadmin@ks.uiuc.edu',
	'To'	  => 	"$username\@ks.uiuc.edu",
	       } );
print $mailer <DATA>;	
$mailer->close;

print <<TEXT;

User creation complete.  You should now go through the following
administative steps:

  o Show the user the internal web pages, especially the following pages:
    - http://www.ks.uiuc.edu/Group/
    - http://www.ks.uiuc.edu/Group/Manual/
    - http://www.ks.uiuc.edu/Group/Computers/
    - http://www.ks.uiuc.edu/Group/Computers/User/Systems/newuser.html
    - http://www.ks.uiuc.edu/
    - http://www.ks.uiuc.edu/~USERNAME (non-Guests only)

  o Give the user a quick tour of the Group.  Key sites:
    - 3D room
    - Front machine room (main file servers)
    - Back machine room (clusters)
    - Center Cubicle (printers, public machines)
    - Terminal Room (public machines)
    - Office locations: Gila, Klaus, Marilyn

  o Remind the user that they also have a UIUC account:
    - Check for mail in both places!
    - E-mail forwarding between these accounts

  o Welcome them aboard!
TEXT

exit 0;

sub Usage {
  warn <<EOM;
$0 v$VERSION
an account creation program for the TCB Group
Usage: $0 [-hdtv]

	-h	Print this message and exit.
	-v	Print the version number and exit.
	-d	Print debugging information.  
	-t 	Testing - just go through the steps, don't make any 
		  actual changes.
EOM
  exit(0);
}

### Things we dropped
# Symlinking /home/infobox into the home directories 
# Making progress report pages (they weren't being used)

### Version History
# v0.90a	Wed Oct 10 11:02:32 CDT 2001
## Initial version
# v0.98a 	Wed Feb 20 13:11:55 CST 2002
## Added Getopt::Std and the various debugging info.
# v0.99b	Tue Feb 18 10:39:50 CST 2003 
## Minor debugging changes; it works well, BTW.
# v1.0		Fri Jan 16 10:03:35 CST 2004 
## Called it a version number for no good reason.  Added email forwarding 
## for g_guests.


__DATA__

Welcome to the Theoretical and Computational Biophysics Group!  This
document ought to help acclimate you to the system.

=== Introductory Web Pages ====================================================

Probably the first thing you'll want to do as a new member is check out
the following web sites carefully.  They outline group policies, which
means you'll have to know them to get by here.

   http://www.ks.uiuc.edu/Group/Manual/
	This is the Group Manual, which outlines just about everything
	administrative about the group.  You'll want to read through 
 	this carefully, if just to get the feel of how the group works.

   http://www.ks.uiuc.edu/Group/Computers/User/Systems/newuser.html
	New user information.  This includes the Appropriate Usage Policy,
	a filesystem tour, and some other useful introductory links.

    http://www.ks.uiuc.edu/Group/Computers/
	The general group computational facility pages.  This includes
	numerous help pages and links to other information.

    http://www.ks.uiuc.edu/Group/Computers/User/
	Help pages for users, this page should be checked for whatever 
	questions you may have.

    http://www.ks.uiuc.edu/Group/Computers/SoftwareGuide/
        Software guide for locally installed software.

Note that you will need to either view these pages from a local system, or
you will need a web password to access them.  This web password should have 
been assigned to you when your account was created if you needed it; if
you don't have one, please contact sysadmin@ks.uiuc.edu.

=== Getting Help ==============================================================

In general, the right way to get help is to mail sysadmin@ks.uiuc.edu.  
Also, if others around you may want to ask them for help; this is a
friendly group, with a lot of diverse skills, and we're generally more
than willing to help each other out.

Note, you may want to first check on the web, at one of the above URLs.
