$VERSION = "1.52";
package TCB::AddressBook::SBook;
our $VERSION = "1.52";

# -*- Perl -*- 		Wed May 19 15:53:55 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2002, Tim Skirvin and UIUC Board of Trustees. Redistribution 
# terms are below.
###############################################################################

=head1 NAME

TCB::AddressBook::SBook - main table for TCB::AddressBook

=head1 SYNOPSIS

  use TCB::AddressBook::SBook

See TCB::AddressBook for more information.

=head1 DESCRIPTION

The 'SBook' table contains all information about the actual address book
(what there is of it).

This table contains the following fields:

 Internal Information 
  ID            Unique numeric ID - auto-generated (INT)

 Basic Information (TINYTEXT fields, unless noted)
  Name		Name of the person.  
  Info		All other information about the person.  (TEXT)

Key fields:     Name

List items:     Name, Info

Required: 	Same as Key fields.

Default order:  ID

Admin Fields:	none

No other tables depend on this table directly.

Doesn't depend on any other table.

=cut

###############################################################################
### Initialization ############################################################
###############################################################################

use vars qw( @ISA $FIELDS $KEYS $NAME $LIST $VERSION $REQUIRED $ADMIN $ORDER );
use strict;
use warnings;
use CGI;
use TCB::AddressBook;

push @ISA, "TCB::AddressBook";

###############################################################################
### Database Variables ########################################################
###############################################################################
$NAME = "AddressBook";
$FIELDS = {
  'ID'   => 'INT NOT NULL PRIMARY KEY AUTO_INCREMENT', 
  'Name' => 'TINYTEXT', 'Info' => 'TEXT'
	 };
$KEYS  = 'Name';
$LIST  = [ 'Name', 'Info' ];
$REQUIRED = $KEYS;
$ADMIN    = [ ];
$ORDER    = [ 'ID' ];

###############################################################################
### Functions #################################################################
###############################################################################

=head2 Internal Functions

=over 4

=item html ( ENTRY, TYPE, OPTIONS )

Prints the HTML version of the table.  Heavily customized for the TCB
environment, but then again so is the whole program.

=cut

sub html {
  my ($self, $entry, $type, $options, @rest) = @_;
  my $cgi = new CGI; 	$entry ||= {};	$options ||= {};

  my @return = <<HTML;
<div class="basetable">
 <div class="row1">
  <span class="label">Name</span>
  <span class="formw">
   @{[ $cgi->textfield('Name', $$entry{Name} || "", 40, 255) ]}
  </span>
 </div>

 <div class="row1">
  <span class="label">Information</span>
  <span class="formw">
   @{[ $cgi->textarea(-name=>'Info', -default=>$$entry{Info} || "",
                      -rows=>7, -cols=>40, -maxlength=>65535) ]}
  </span>
 </div>
 
 <div class="submitbar"> @{[ $cgi->submit(-name=>"Submit") ]} </div>
</div>
HTML
  wantarray ? @return : join("\n", @return);
}

sub text {}

=back

=cut


###############################################################################
##### main() ##################################################################
###############################################################################

TCB::AddressBook->table_add($NAME, $FIELDS, $KEYS, $LIST, $ORDER, 
                            $ADMIN, $REQUIRED, \&html, \&text);

=head1 NOTES

The group Address Book is based in a mysql database, which was transferred
from an msql database.  It's old, and crufty.  It's also completely inadequate
for doing what a real address book should do - keep track of all of the
fields separately, for easier searching.  *sigh*  Well, there's not much
we can do about it, besides start over.

(We have started over, actually...but that has nothing to do with this
package.)

=head1 REQUIREMENTS

Perl 5 or better, DBIx::Frame, TCB::AddressBook.

=head1 SEE ALSO

B<TCB::AddressBook>, B<tbtel>, B<DBIx::Frame>, B<DBIx::Frame::CGI>

=head1 AUTHOR

Tim Skirvin <tskirvin@ks.uiuc.edu>

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-addressbook/>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-addressbook/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.5         	Fri Jul 27 10:01:57 CDT 2001
### Put the code base into DBI::Frame base, and commented the code.  Created
### the various .cgi files associated with the package.
# v1.51 	Tue Apr  2 13:09:18 CST 2002
### Took out the DEFAULT variable, since it's not being used.
# v1.52		Wed May 19 15:54:19 CDT 2004 
### Changing over to DBIx::Frame.
