use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $modules = {
  'TCB/AddressBook.pm'	    => '$(INST_LIBDIR)/AddressBook.pm',
  'TCB/AddressBook/SBook.pm'    => '$(INST_LIBDIR)/AddressBook/SBook.pm',
};

my $man3 = {
  'TCB/AddressBook.pm'       => '$(INST_MAN3DIR)/TCB::AddressBook.3',
  'TCB/AddressBook/SBook.pm' => '$(INST_MAN3DIR)/TCB::AddressBook::SBook.3',
};

my $man1 = {
  'tbtel'		    => '$(INST_MAN1DIR)/tbtel.1'
};

my $progs = [ 'addressbook_admin.cgi', 'addressbook_index.cgi',
	      'addressbook_list.cgi',  'addressbook_create.pl', 'tbtel',
	      'addressbook_allnames.cgi' ];

WriteMakefile(
    'NAME'	=> 'TCB::AddressBook',
    'DISTNAME'  => 'TCB-AddressBook',
    'MAN3PODS'  => $man3,  
    'MAN1PODS'  => $man1,
    'VERSION_FROM' => 'TCB/AddressBook.pm', # finds $VERSION
    'PREREQ_PM' => { 'DBIx::Frame' => 1.05 },
    'PM' 	=> $modules,
    'EXE_FILES' => $progs,
    'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
    'AUTHOR'    => 'tskirvin@ks.uiuc.edu (Tim Skirvin)',
    'ABSTRACT_FROM'  => 'TCB/AddressBook.pm',
);
