/*
 *  serial.c -- Machine/OS dependent serial I/O code
 *
 *  Copyright 1997 (Unix code)  John E. Stone (johns@megapixel.com)
 *                                            (j.stone@acm.org)
 *
 *  $Id: serial.c,v 1.1 2001/04/11 00:04:25 johns Exp $
 *
 */


/*
 * Unix serial I/O code by John Stone
 */

#define _POSIX_SOURCE 1

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include "serial.h" /* protos and types for this file */

typedef struct {
  int fd;        /* serial port device file descriptor */
} commstruct;

int serial_comm_open(char * commname, SerialCommHandle * commhandleptr) {
  struct termios serialtermio;
  commstruct * comm;

  *commhandleptr = NULL;

  comm = malloc(sizeof(commstruct));
  if (comm == NULL)
    return -1;

/*  comm->fd = open(commname, O_RDWR | O_NONBLOCK | O_NOCTTY); */
  comm->fd = open(commname, O_RDWR | O_NOCTTY);

  if (comm->fd == -1) {
    free(comm);
    return -1;  /* failed open of comm port */
  }
  tcgetattr(comm->fd, &serialtermio);

  serialtermio.c_lflag = 0;
  serialtermio.c_lflag = 0;
  serialtermio.c_iflag = IGNBRK | IGNPAR;
  serialtermio.c_oflag = 0;
  serialtermio.c_cflag =  B9600 | CREAD | CS8 | CLOCAL | HUPCL;
  serialtermio.c_cc[VEOL] = '\r';
  serialtermio.c_cc[VERASE] = 0;
  serialtermio.c_cc[VKILL] = 0;
  serialtermio.c_cc[VMIN] = 0;
  serialtermio.c_cc[VTIME] = 0;

  tcsetattr(comm->fd, TCSAFLUSH, &serialtermio);

  *commhandleptr = (SerialCommHandle) comm;
 
  return 0;
}

int serial_comm_write(SerialCommHandle commhandle, char * buf, int len) {
  commstruct * comm = (commstruct *) commhandle;

  if (comm == NULL) 
    return -1;

  return write(comm->fd, buf, len);
}

int serial_comm_read(SerialCommHandle commhandle, char * buf, int sz) {
  commstruct * comm = (commstruct *) commhandle;

  if (comm == NULL) 
    return -1;

  return read(comm->fd, buf, sz);
}

int serial_comm_close(SerialCommHandle * commhandleptr) {
  commstruct * comm = (commstruct *) (*commhandleptr);

  if (comm == NULL)
    return -1;

  close(comm->fd);

  free(*commhandleptr);
  *commhandleptr = NULL;

  return 0;
}

