/*
 *   Projector control program for Electrohome Marquee series projectors. 
 * 
 *   Copyright 2001 Board of Trustees of the University of Illinois
 *   John E. Stone (johns@ks.uiuc.edu) (j.stone@acm.org) (johns@megapixel.com)
 *
 *   $Id: main.c,v 1.3 2001/04/11 03:11:46 johns Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include "serial.h"

int poweron(SerialCommHandle commhandle) {
  char buf[14];

  printf("Sending all projectors power on sequence\n");

  buf[ 0] = 0x01;
  buf[ 1] = 0x08;
  buf[ 2] = 0x80;
  buf[ 3] = 0x00;
  buf[ 4] = 0x1b;
  buf[ 5] = 0x93;
  buf[ 6] = 0xff;

  buf[ 7] = 0x63;
  buf[ 8] = 0x30;
  buf[ 9] = 0x24;
  buf[10] = 0x51;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 

  buf[ 7] = 0x63;
  buf[ 8] = 0x24;
  buf[ 9] = 0x24;
  buf[10] = 0x45;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 
}


int poweroff(SerialCommHandle commhandle) {
  char buf[14];

  printf("Sending all projectors power off sequence\n");

  buf[ 0] = 0x01;
  buf[ 1] = 0x08;
  buf[ 2] = 0xb0;
  buf[ 3] = 0x00;
  buf[ 4] = 0x1b;
  buf[ 5] = 0x93;
  buf[ 6] = 0xff;

  buf[ 7] = 0x63;
  buf[ 8] = 0x30;
  buf[ 9] = 0x24;
  buf[10] = 0x81;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 

  buf[ 7] = 0x63;
  buf[ 8] = 0x14;
  buf[ 9] = 0x24;
  buf[10] = 0x65;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 
}


int standbyon(SerialCommHandle commhandle) {
  char buf[14];

  printf("Sending all projectors standby on sequence\n");

  buf[ 0] = 0x01;
  buf[ 1] = 0x08;
  buf[ 2] = 0xb0;
  buf[ 3] = 0x00;
  buf[ 4] = 0x1b;
  buf[ 5] = 0x93;
  buf[ 6] = 0xff;

  buf[ 7] = 0x63;
  buf[ 8] = 0x30;
  buf[ 9] = 0x24;
  buf[10] = 0x81;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 

  buf[ 7] = 0x63;
  buf[ 8] = 0x3c;
  buf[ 9] = 0x24;
  buf[10] = 0x8d;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 
}


int standbyoff(SerialCommHandle commhandle) {
  char buf[14];

  printf("Sending all projectors standby off sequence\n");

  buf[ 0] = 0x01;
  buf[ 1] = 0x08;
  buf[ 2] = 0xb0;
  buf[ 3] = 0x00;
  buf[ 4] = 0x1b;
  buf[ 5] = 0x93;
  buf[ 6] = 0xff;

  buf[ 7] = 0x63;
  buf[ 8] = 0x30;
  buf[ 9] = 0x24;
  buf[10] = 0x81;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 

  buf[ 7] = 0x63;
  buf[ 8] = 0x0c;
  buf[ 9] = 0x24;
  buf[10] = 0x5d;
  buf[11] = 0x0e;

  serial_comm_write(commhandle, buf, 12); 
}


int main(int argc, char **argv) {
  char * portname; 
  SerialCommHandle commhandle;
  int i;

  if (argc < 3) {
    printf("Usage: %s /dev/ttyb command1 command2 ...\n", argv[0]);
    printf("Commands are executed in sequence separated by 1 second delays.\n");
    printf("Available commands are:\n");
    printf("   poweron - power on all projectors\n");
    printf("  poweroff - power down all projectors\n");
    printf(" standbyon - put all projectors on standby, offline\n");
    printf("standbyoff - take all projectors off of standby, fully online\n");
    printf("\n");
    return -1;
  }

  portname = argv[1];

  if (serial_comm_open(portname, &commhandle) == -1) {
    printf("Failed to open serial port device %s\n", portname);
    return -1;
  }

  for (i=2; i<argc; i++) {
    if (!strcmp(argv[i], "poweron")) {
      poweron(commhandle);
    }
    else if (!strcmp(argv[i], "poweroff")) {
      poweroff(commhandle);
    }
    else if (!strcmp(argv[i], "standbyoff")) {
      standbyoff(commhandle);
    }
    else if (!strcmp(argv[i], "standbyon")) {
      standbyon(commhandle);
    }
    else {
      printf("Invalid option '%s' ignored.\n", argv[i]);
    }

    sleep(1); /* pause for one second between projector commands */
  }
 
  serial_comm_close(&commhandle);

  return 0;
}

