/*
 * step_output.c
 */

#include <stdarg.h>
#include <stdio.h>
#include "step/step_defn.h"


int step_output(Step *s, const char *fmt, ...)
{
  char sbuf[512];
  int ret;
  va_list ap;

  /* callback */
  void *messageObjPtr = s->param->messageObjPtr;
  int (*output_message)(void *, const char *) = s->param->output_message;

  /* formulate output string from variable args list */
  va_start(ap, fmt);
  ret = vsnprintf(sbuf, sizeof(sbuf), fmt, ap);
  va_end(ap);
  if (ret < 0) {
    return step_error(s, "vsnprintf() returned an error");
  }
  else if (ret >= (int)sizeof(sbuf)) {
    /* terminate truncated output with newline */
    sbuf[sizeof(sbuf)-2] = '\n';
    sbuf[sizeof(sbuf)-1] = '\0';  /* redundant? */
  }

  /* invoke callback */
  if (output_message(messageObjPtr, sbuf)) {
    return step_error(s, "output_message() returned an error");
  }

  return STEP_SUCCESS;
}
