/*
 * step_force.c
 */

#include "step/step_defn.h"


int step_force(Step *s)
{
  const int32 options = s->param->options;
  const MD_Dvec *pos = s->system->pos;
  MD_Dvec *f = s->system->force;
  double *pe = &(s->system->potential_energy);

  void *forceObjPtr = s->param->forceObjPtr;
  int (*compute_force)(void *, double *, MD_Dvec *, const MD_Dvec *)
    = s->param->compute_force;

  if (options & STEP_ZEROLINMO) {
    return step_error(s, "zero linmo not yet supported by step library");
  }

  /* callback */
  if (compute_force(forceObjPtr, pe, f, pos)) {
    return step_error(s, "compute_force() returned an error");
  }

  return STEP_SUCCESS;
}
