/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 *
 * nosehoover.c  - Compute implicit Nose-Hoover integration.
 */

#include <stdlib.h>
#include "step/intdef.h"
#include "debug/debug.h"


int step_init_nosehoover(Step *s, StepParam *param)
{
  return 0;  /* nothing to do! */
}

void step_done_nosehoover(Step *s)
{
  return;  /* nothing to do! */
}


int step_compute_nosehoover(Step *s, StepSystem *sys, int32 numsteps)
{
  const double dt = s->param->timestep;
  const double half_dt = 0.5 * dt;
  double konst;
  double pe;
  void *f_obj = s->param->force_object;
  int32 (*f_eval)(void *, double *, MD_Dvec *, MD_Dvec *)
    = s->param->force_compute;
  MD_Dvec *f = sys->force;
  MD_Dvec *vel = sys->vel;
  MD_Dvec *pos = sys->pos;
  MD_Dvec *half_vel = s->half_vel;
  const double *scal_inv_mass = s->scal_inv_mass;
  const int32 natoms = s->param->natoms;
  int32 n, i;

  double xi, eta;  /* extended Lagrangian momentum and position */
  const double dt_twoq = s->dt_over_twice_qmass;
  const double s_twoke = s->twice_desired_ke;


  /* compute force if not valid */
  if ( ! sys->is_force_valid) {
    if (f_eval(f_obj, &pe, f, pos)) return STEP_FAIL;

#if 0
    if (numsteps == 0) {
      /* need previous half-positions before returning */
      for (i = 0;  i < natoms;  i++) {
        konst = -half_dt * scal_inv_mass[i];
        half_vel[i].x = vel[i].x + konst * f[i].x;
        half_vel[i].y = vel[i].y + konst * f[i].y;
        half_vel[i].z = vel[i].z + konst * f[i].z;
      }
    }
#endif
    sys->is_force_valid = STEP_TRUE;
    s->xi = 0;
    s->eta = 0;
  }
  xi = s->xi;
  eta = s->eta;

  /* */
  for (n = 0;  n < numsteps;  n++) {

    /* half kick */
    for (i = 0;  i < natoms;  i++) {
      c1 = half_dt * scal_inv_mass[i];
      c2 = half_dt * xi;
      half_vel[i].x = vel[i].x + c1 * f[i].x - c2 * vel[i].x;
      half_vel[i].y = vel[i].y + c1 * f[i].y - c2 * vel[i].y;
      half_vel[i].z = vel[i].z + c1 * f[i].z - c2 * vel[i].z;
    }
    twoke = 0;
    for (i = 0;  i < natoms;  i++) {
      twoke += (half_vel[i].x * half_vel[i].x + half_vel[i].y * half_vel[i].y
          + half_vel[i].z * half_vel[i].z) * atom[i].m;
    }
    half_xi = xi + dt_twoq * (twoke - s_twoke);

    /* drift */
    for (i = 0;  i < natoms;  i++) {
      pos[i].x += dt * half_vel[i].x;
      pos[i].y += dt * half_vel[i].y;
      pos[i].z += dt * half_vel[i].z;
    }
    eta += dt * half_xi;

    /* compute force for updated position */
    if (f_eval(f_obj, &pe, f, pos)) {
      sys->is_force_valid = STEP_FALSE;
      return STEP_FAIL;
    }

    /* half kick */
    twoke = 0;
    for (i = 0;  i < natoms;  i++) {
      konst = half_dt * scal_inv_mass[i];
      vel[i].x = half_vel[i].x + konst * f[i].x;
      vel[i].y = half_vel[i].y + konst * f[i].y;
      vel[i].z = half_vel[i].z + konst * f[i].z;
      twoke += (vel[i].x * vel[i].x + vel[i].y * vel[i].y
          + vel[i].z * vel[i].z) * atom[i].m;
    }
    xi_tilde = half_xi - dt_twoq * s_twoke;
    xi = xi_tilde;  /* initial guess */
    solve(&xi, -xi_tilde, half_dt, -dt_twoq * twoke);
    konst = 1.0 / (1.0 + half_dt * xi);
    twoke = 0;
    for (i = 0;  i < natoms;  i++) {
      vel[i].x *= konst;
      vel[i].y *= konst;
      vel[i].z *= konst;
      twoke += (vel[i].x * vel[i].x + vel[i].y * vel[i].y
          + vel[i].z * vel[i].z) * atom[i].m;
    }

    extended_energy = pe + MD_KCAL_MOL * (0.5 * twoke
        + 0.5 * qmass * xi * xi + s_twoke * eta);


  }

  return 0;
}


/*
 * solve root of cubic:  (x+a)(bx+1)^2 + c = 0
 */
int solve(double *x, double a, double b, double c)
{
}

