/* modified from NAMD */

/**
***  Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000 by
***  The Board of Trustees of the University of Illinois.
***  All rights reserved.
**/

#ifndef COMPUTEPME_H
#define COMPUTEPME_H

//#include "ComputeHomePatches.h"
#include "pmetest/pmetest.h"
#include "pmetest/PmeBase.h"
#include "pmetest/Vector.h"
//#include "NamdTypes.h"

class PmeRealSpace;
class ComputePmeMgr;
//class ComputeMgr;
//class SubmitReduction;
//class PmeGridMsg;

/*
struct PmeParams {
  double PMETolerance;
  int PMEGridSizeX;
  int PMEGridSizeY;
  int PMEGridSizeZ;
  int PMEInterpOrder;
  Vector cellBasisVector1;
  Vector cellBasisVector2;
  Vector cellBasisVector3;
  Vector cellOrigin;
  double cutoff;
  double scaling;
  double dielectric_1;
  double ewaldcof;
};
*/

class ComputePme { //: public ComputeHomePatches {
public:
  ComputePme(const PmetestParams &); //ComputeID c);
  virtual ~ComputePme();
//  void doWork();
  void doWork(int natoms, const Vector *position, const double *charge,
              Vector *force, double *energy, double *virial);
            // energy is length 1, virial is length 9
//  void sendData(int, int, int*, int*);
//  void copyResults(PmeGridMsg *);
  void ungridForces();

  PmetestParams *simParams;
 private:
  ComputePmeMgr *computePmeMgr;
  PmeGrid myGrid;
  int qsize, fsize, bsize;
public:
  double **q_arr;
private:
  char *f_arr;
  char *fz_arr;
public:
  double energy;
  double virial[6];
private:
//  SubmitReduction *reduction;
  int resultsRemaining;
  PmeRealSpace *myRealSpace;
  int numLocalAtoms;
  PmeParticle *localData;

  Vector *pmeForce;
  double *pmeVirial;
  PmetestParams storePmeParams;

  int useAvgPositions;
};

#endif

