/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * lattice.h
 */

#ifndef LATTICE_H
#define LATTICE_H

#include "mdapi/mdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct MgridLattice_tag {
    void *databuffer;   /* start of allocated data buffer */
    void *data;         /* transformed pointer for index ranges */
    int32 elemsz;       /* size in bytes of grid elements */
    int32 ia, ib, ni;   /* index range and length along i dimension */
    int32 ja, jb, nj;   /*   along j dimension */
    int32 ka, kb, nk;   /*   along k dimension */
    int32 nelems;       /* number of elements in grid */
    int32 nbytes;       /* total number of bytes allocated */
  } MgridLattice;


  /* constructor, initialize memory */
  int mgrid_lattice_init(MgridLattice *);

  /* setup lattice memory buffer allocation and indexing */
  int mgrid_lattice_setup(MgridLattice *, int32 elemsz,
      int32 ia, int32 ib, int32 ja, int32 jb, int32 ka, int32 kb);

  /* zero lattice memory buffer */
  int mgrid_lattice_zero(MgridLattice *);

  /* get pointer to element, perform index range checking */
  void *mgrid_lattice_elem(MgridLattice *, int32 i, int32 j, int32 k);

  /* destructor, free memory allocation */
  void mgrid_lattice_done(MgridLattice *);

  /* for debugging */
  int mgrid_lattice_print(MgridLattice *);

#ifdef __cplusplus
}
#endif

#endif /* LATTICE_H */
