/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * engparam.h
 */

#ifndef ENGPARAM_H
#define ENGPARAM_H

#include "mdapi/mdfront.h"
#include "adt/list.h"
#include "adt/table.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct EngParamMember_tag {
    union {               /* container for type converted value */
      char c;
      int32 n;
      float f;
      double d;
      MD_Fvec fv;
      MD_Dvec dv;
      const char *s;      /* for string, point to configinfo[].value */
    } val;
    const char *name;     /* points to configinfo[].keyword */
    int32 type;           /* type number from MDAPI */
    int32 len;            /* length may be greater than one for strings */
    int32 isparam;        /* true if member of "Param" engine-defined type */
    int32 isstr;          /* true if val.s points to string value */
  } EngParamMember;

  typedef struct EngParam_tag {
    adt_List member;      /* list of EngParamMember */
    adt_Table name;       /* hash table of names to avoid reinit of params */
    MD_Engine *eng;       /* points to engine */
    char *buf;            /* buffer for MD_NAME, MD_STRING, and MD_MESSAGE */
    int32 buflen;         /* length of buffer */
    int32 param_id;       /* identification number for engine "param" */
    MD_Attrib param_attr; /* attributes for engine "param" */
    void *param_obj;      /* stores instance of Param type */
  } EngParam;

  int engparam_init(EngParam *);
  int engparam_setup(EngParam *, MD_Engine *);
  int engparam_set(EngParam *, const char *keywd, const char *val);
  int engparam_check(EngParam *);
  void engparam_done(EngParam *);

#ifdef DEBUG_SUPPORT
  int engparam_debug(EngParam *);
#endif

#ifdef __cplusplus
}
#endif

#endif /* ENGPARAM_H */
