/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 */

/**@file    mdio.h
 * @brief   Molecular dynamics I/O library.
 * @author  David J. Hardy
 * @date    2003-2005
 *
 * The MDIO library contains easily used file readers and writers
 * for some basic file formats, utilizing the MDAPI data structures.
 * In particular, the arrays of force field parameter and topology
 * data types from @c mdapi/mdtypes.h are correctly populated and
 * cross-indexed.
 *
 * The MDIO library is object-oriented.  The following "classes" are
 * provided to read and/or write the various types of files:
 * @li @c mdio_Config_t - reading NAMD-style configuration files
 *   (i.e. @c keyword = @c value)
 * @li @c mdio_Param_t - reading X-Plor force field parameter files
 * @li @c mdio_Topo_t - reading X-Plor PSF "topology" files
 * @li @c mdio_Pdbcoord_t - reading and writing PDB coordinate files
 * @li @c mdio_Bincoord_t - reading and writing NAMD binary coordinate files
 * @li @c mdio_Dcd_t - writing DCD trajectory files (less than 2 GB in size)
 */

#ifndef MDIO_H
#define MDIO_H

#include "mdio/file.h"
#include "mdio/config.h"
#include "mdio/param.h"
#include "mdio/topo.h"
#include "mdio/pdbcoord.h"
#include "mdio/bincoord.h"
#include "mdio/dcd.h"

#endif /* MDIO_H */
