#!/usr/bin/env python

import sys

def quit_early(fout, outfile):
  import os
  fout.close()
  os.remove(outfile)
  print >> sys.stderr, "terminating prematurely"
  sys.exit()


def add_drude_particle(water, atomcnt, fout, outfile):
  if atomcnt + 4 >= 100000:
    print >> sys.stderr, "too many atoms"
    quit_early(fout, outfile)
  atomname = [ "OH2", "H1 ", "H2 " ]
  newatomname = [ "OH2D", "H1D ", "H2D " ]
  newresiduename = "PSPC"
  drudename = "DRU "
  for i in range(3):
    line = water[i]
    if line[0:4] != "ATOM":
      print >> sys.stderr, "did not find expected ATOM record in water molecule"
      quit_early(fout, outfile)
    if line[17:21] != "TIP3":
      print >> sys.stderr, "expecting TIP3 label in water molecule"
      quit_early(fout, outfile)
    if line[13:16] != atomname[i]:
      print >> sys.stderr, "did not find expected atom name in water molecule"
      quit_early(fout, outfile)
    atomcnt += 1
    line = line[:6] + "%5d" % atomcnt + line[11:12] + newatomname[i] \
        + line[16:17] + newresiduename + line[21:]
    fout.write(line)

  line = water[0]
  atomcnt += 1
  line = line[:6] + "%5d" % atomcnt + line[11:12] + drudename \
      + line[16:17] + newresiduename + line[21:]
  fout.write(line)
  return atomcnt


def polarize_tip3_water(infile, outfile):
  """
  Convert each TIP3 water molecule found in a PDB file into a PSPC water
  with an added Drude particle, renumbering the ATOM records accordingly
  """

  fin = open(infile, "r")
  fout = open(outfile, "w")

  waterlinecnt = 0
  atomcnt = 0
  water = [None] * 3

  for line in fin:
    if waterlinecnt == 2:
      # get last line of water and process
      if line[17:21] != "TIP3":
        print >> sys.stderr, "expecting continuation of water molecule"
        quit_early(fout, outfile)
      water[waterlinecnt] = line
      atomcnt = add_drude_particle(water, atomcnt, fout, outfile)
      waterlinecnt = 0

    elif line[0:4] == "ATOM":
      # is this water?
      if line[17:21] == "TIP3":
        water[waterlinecnt] = line
        waterlinecnt += 1
      elif waterlinecnt != 0:
        print >> sys.stderr, "expecting continuation of water molecule"
        quit_early(fout, outfile)
      else:
        atomcnt += 1
        if atomcnt == 100000:
          print >> sys.stderr, "too many atoms"
          quit_early(fout, outfile)
        line = line[:6] + "%5d" % atomcnt + line[11:]
        fout.write(line)

    else:
      # just echo line to output file
      fout.write(line)


if __name__ == "__main__":
  if len(sys.argv) != 3:
    print >> sys.stderr, \
"""
Convert each TIP3 water molecule found in a PDB file into a PSPC water
with an added Drude particle, renumbering the ATOM records accordingly
"""
    print >> sys.stderr, "syntax: %s pdbfile1 pdbfile2" % sys.argv[0]
    sys.exit()

  polarize_tip3_water(sys.argv[1], sys.argv[2])
