/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * demo_param.c - demonstrate reading X-Plor force field parameter files
 */

#include <stdlib.h>
#include <stdio.h>
#include "mdio/param.h"
#include "debug/debug.h"


int main(int argc, char *argv[])
{
  mdio_Param *prm;
  MD_AtomPrm *atomprm;
  MD_BondPrm *bondprm;
  MD_AnglePrm *angleprm;
  MD_TorsPrm *dihedprm;
  MD_TorsPrm *imprprm;
  MD_NbfixPrm *nbfixprm;
  int natomprm;
  int nbondprm;
  int nangleprm;
  int ndihedprm;
  int nimprprm;
  int nnbfixprm;
  int k;

  /* setup */
  if ((prm = mdio_createParam()) == NULL) {
    BUG("can\'t create param reader object");
  }

  /* read param files */
  for (k = 1;  k < argc;  k++) {
    printf("Reading params from \"%s\"\n", argv[k]);
    if (mdio_readParam(prm, argv[k])) {
      printf("FAILED!\n");
    }
    else {
      printf("Success!\n");
    }
  }

  /* obtain data */
  atomprm = mdio_getAtomParam(prm, &natomprm);
  bondprm = mdio_getBondParam(prm, &nbondprm);
  angleprm = mdio_getAngleParam(prm, &nangleprm);
  dihedprm = mdio_getDihedParam(prm, &ndihedprm);
  imprprm = mdio_getImprParam(prm, &nimprprm);
  nbfixprm = mdio_getNbfixParam(prm, &nnbfixprm);

  /* print data */
  for (k = 0;  k < natomprm;  k++) {
    MD_AtomPrm *p = &atomprm[k];
    printf("atomprm[%d]: emin=%g rmin=%g emin14=%g rmin14=%g %s\n",
        k, p->emin, p->rmin, p->emin14, p->rmin14, p->type);
  }
  for (k = 0;  k < nbondprm;  k++) {
    MD_BondPrm *p = &bondprm[k];
    printf("bondprm[%d]: k=%g r0=%g %s %s\n",
        k, p->k, p->r0, p->type[0], p->type[1]);
  }
  for (k = 0;  k < nangleprm;  k++) {
    MD_AnglePrm *p = &angleprm[k];
    printf("angleprm[%d]: k_theta=%g theta0=%g k_ub=%g r_ub=%g %s %s %s\n",
        k, p->k_theta, p->theta0, p->k_ub, p->r_ub,
        p->type[0], p->type[1], p->type[2]);
  }
  for (k = 0;  k < ndihedprm;  k++) {
    MD_TorsPrm *p = &dihedprm[k];
    printf("dihedprm[%d]: k_tor=%g phi=%g n=%d mult=%d %s %s %s %s\n",
        k, p->k_tor, p->phi, p->n, p->mult,
        p->type[0], p->type[1], p->type[2], p->type[3]);
  }
  for (k = 0;  k < nimprprm;  k++) {
    MD_TorsPrm *p = &imprprm[k];
    printf("imprprm[%d]: k_tor=%g phi=%g n=%d mult=%d %s %s %s %s\n",
        k, p->k_tor, p->phi, p->n, p->mult,
        p->type[0], p->type[1], p->type[2], p->type[3]);
  }
  for (k = 0;  k < nnbfixprm;  k++) {
    MD_NbfixPrm *p = &nbfixprm[k];
    printf("nbfixprm[%d]: emin=%g rmin=%g emin14=%g rmin14=%g %d %d %s %s\n",
        k, p->emin, p->rmin, p->emin14, p->rmin14,
        p->prm[0], p->prm[1], p->type[0], p->type[1]);
  }

  /* cleanup reader */
  mdio_destroyParam(prm);

  return 0;
}
