/*
 * Copyright (C) 2004-2005 by David J. Hardy.  All rights reserved.
 *
 * demo_config.c - demonstrate reading NAMD-style config file
 */

#include <stdio.h>
#include <stdlib.h>
#include "mdio/config.h"
#include "debug/debug.h"


int main(int argc, char *argv[])
{
  int k, nelems;
  const mdio_ConfigData *data;
  mdio_Config *cfg;

  /* construct config reader object */
  if ((cfg = mdio_createConfig()) == NULL) {
    BUG("can\'t create config reader object");
  }

  /* read in all config files listed on command line */
  for (k = 1;  k < argc;  k++) {
    mdio_readConfig(cfg, argv[k]);
  }

  /* obtain and print config file data */
  data = mdio_getDataConfig(cfg, &nelems);
  printf("Data from config files:  _KEYWORD_ = _VALUE_  (file, linenum)\n");
  for (k = 0;  k < nelems;  k++) {
    printf("_%s_ = _%s_  (%s, %d)\n",
        data[k].keyword, data[k].value, data[k].filename, data[k].linenum);
  }

  /* destroy config file */
  mdio_destroyConfig(cfg);

  return 0;
}
