/*
 * Copyright (C) 2003-2004 by David J. Hardy.  All rights reserved.
 *
 * mdsync.c - subsystem for handling synchronization between
 *     front end and engine
 */

#include <stdlib.h>
#include <string.h>
#include "mdapi/mddef.h"
#include "debug/debug.h"


#define NELEMS(a)  (sizeof(a) / sizeof(a[0]))


/*
 * front end API
 */

int32 MD_test(MD_Engine *s)
{
  /* single threaded implementation, blocking call always done */
  return 1;
}


int32 MD_wait(MD_Engine *s)
{
  /* single threaded implementation, blocking call always done */
  return 0;
}


/*
 * engine API
 */

int32 MD_test_callback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 1;
}


int32 MD_wait_callback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 0;
}


int32 MD_test_fcallback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 1;
}


int32 MD_wait_fcallback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 0;
}


int32 MD_test_msgcallback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 1;
}


int32 MD_wait_msgcallback(MD_Front *s)
{
  /* single threaded implementation, blocking call always done */
  return 0;
}
