#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "force/force.h"

#define PARAM_FB
#define EV_TO_KCAL_PER_MOL  (23.060538)
#if defined(PARAM_FB)
const double a_si_o  = 10454.202 * EV_TO_KCAL_PER_MOL;  /* kcal/mol */
const double a_o_o   =  1428.406 * EV_TO_KCAL_PER_MOL;  /* kcal/mol */
const double a_si_si = 79502.113 * EV_TO_KCAL_PER_MOL;  /* kcal/mol */
const double b_si_o  = 0.208;                           /* Ang */
const double b_o_o   = 0.358;                           /* Ang */
const double b_si_si = 0.201;                           /* Ang */
const double c_si_o  =  63.047 * EV_TO_KCAL_PER_MOL;    /* Ang^6 kcal/mol */
const double c_o_o   =  41.374 * EV_TO_KCAL_PER_MOL;    /* Ang^6 kcal/mol */
const double c_si_si = 446.780 * EV_TO_KCAL_PER_MOL;    /* Ang^6 kcal/mol */
#endif

int main(int argc, char *argv[])
{
  double a, b, c;
  double r, r2, u, du_r;
  int n, m = 6000;  /* number of points to plot */
  double r0 = 1.0;  /* starting distance */
  double s = 1e-3;  /* step size */
  int is_energy;

  if (argc == 3) {
    if (strcmp(argv[1], "energy")==0) is_energy = 1;
    else if (strcmp(argv[1], "force")==0) is_energy = 0;
    else is_energy = -1;
    if (strcmp(argv[2], "si-o")==0) {
      a = a_si_o;
      b = b_si_o;
      c = c_si_o;
    }
    else if (strcmp(argv[2], "o-o")==0) {
      a = a_o_o;
      b = b_o_o;
      c = c_o_o;
    }
    else if (strcmp(argv[2], "si-si")==0) {
      a = a_si_si;
      b = b_si_si;
      c = c_si_si;
    }
    else is_energy = -1;
  }
  else {
    is_energy = -1;
  }

  if (is_energy < 0) {
    printf("syntax:  %s [energy|force] [si-o|o-o|si-si]\n", argv[0]);
    exit(0);
  }

  if (is_energy) printf("# distance  potential\n");
  else printf("# distance  force signed magnitude\n");

  for (n = 0;  n < m;  n++) {
    r = r0 + s*n;
    r2 = r*r;
    force_compute_nbpairs_vdw_buck(&u, &du_r, r2, a, b, c);
    if (is_energy) printf("%g %g\n", r, u);
    else printf("%g %g\n", r, -r*du_r);
  }
  return 0;
}
