/*
 * Copyright (C) 2004-2006 by David J. Hardy.  All rights reserved.
 */

/**@file    intdefn.h
 * @brief   Internal definitions for force class.
 * @author  David J. Hardy
 * @date    2004-2006
 */

#ifndef INTDEFN_H
#define INTDEFN_H

#include <stdio.h>
#include <stdlib.h>
#include "force/force.h"

#define DEBUG_PAIRLISTS
#undef DEBUG_PAIRLISTS

#define DEBUG_GRIDCELLS
#undef DEBUG_GRIDCELLS

#define DEBUG_VDWPARAMS
#undef DEBUG_VDWPARAMS

#define ERROR(msg)  \
  fprintf(stderr, "FORCE ERROR:  file %s, line %d:  %s\n", \
      __FILE__, __LINE__, msg);

/* make sure cell basis vectors aren't (nearly) linearly independent */
#define TOL_CELL_BASIS  0.01

/*
 * how far apart should domain walls be as multiple of max distance?
 * (for nonperiodic boundary conditions)
 */
#define DOMAIN_LEN_FRAC  0.9

/*
 * how often should nonperiodic domain be re-centered?
 */
#define MAX_STEPS  10

#define OFFSET_INDEX(i,j,k)  ((((k)*3 + (j))*3 + (i)) + 13)

#if defined(DEBUG_PAIRLISTS) || defined(DEBUG_GRIDCELLS)
#undef MIN
#define MIN(a,b)  ( (a) < (b) ? (a) : (b) )
#undef MAX
#define MAX(a,b)  ( (a) > (b) ? (a) : (b) )
#endif


#endif /* INTDEFN_H */
