/*
 * Copyright (C) 2005 by David J. Hardy.  All rights reserved.
 */

#include <stdlib.h>
#include <string.h>
#include "force/force.h"
#include "debug/debug.h"


ForceDomain *force_domain_create(void)
{
  ForceDomain *fdom;

  fdom = (ForceDomain *) malloc(sizeof(ForceDomain));
  if (fdom == NULL) {
    return NULL;
  }
  else if (force_domain_initialize(fdom)) {
    force_domain_cleanup(fdom);
    free(fdom);
    return NULL;
  }
  return fdom;
}


int force_domain_initialize(ForceDomain *fdom)
{
  ASSERT(fdom != NULL);
  /* clear memory */
  memset(fdom, 0, sizeof(ForceDomain));
  return 0;
}


void force_domain_destroy(ForceDomain *fdom)
{
  force_domain_cleanup(fdom);
  free(fdom);
}


void force_domain_cleanup(ForceDomain *fdom)
{
  ASSERT(fdom != NULL);
  /* no memory was allocated by us, simply reset contents */
  memset(fdom, 0, sizeof(ForceDomain));
}
