/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * Store an certain number of previous vectors of MD_Double, which are used 
 * for, e.g. predictions.  
 */

#ifndef VEC_BUFFER_H
#define VEC_BUFFER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "mdtypes.h"

struct VecBuffer_Tag {
  MD_Int ntotalvec;    /* buffer has ntotalvec vectors */
  MD_Int nvec;         /* currently how many vectors are in the buffer */
  MD_Int veclen;       /* each vector is this long */
  MD_Double *buffer;   /* can I use char ? */
  MD_Int last_offset;  /* offset of the last vector stored */
};


MD_Int vec_buffer_init(struct VecBuffer_Tag *vb, MD_Int nvec, MD_Int veclen,
		       const MD_Char *filename);
MD_Int vec_buffer_destroy(struct VecBuffer_Tag *vb);

/* store a new vector  into buffer, which may overwrite old data */
MD_Int vec_buffer_update(struct VecBuffer_Tag *vb, const MD_Double *vec);

/* Retrieve the latest stored "nvec" vectors, and assign pointers pointing 
 * to their head to vecarray, starting from the latest.
 * if nvec is greater than the number of vectors stored in the buffer,
 * the return value will be nonzero, and a warning message is printed.
 * Only the max(nvec, vb->nvec) number of pointers are assigned.
 * It is the user's responsibility to make sure that he does not ask for
 * more than those stored. 
 */ 
MD_Int vec_buffer_get_vec_array(struct VecBuffer_Tag *vb, 
				MD_Double **vecarray, MD_Int nvec);

MD_Int vec_buffer_get_nvec(struct VecBuffer_Tag *vb);
MD_Int vec_buffer_get_veclen(struct VecBuffer_Tag *vb);

/* store the content of buffer into disk file, assume the buffer is full */
MD_Int vec_buffer_bindump(struct VecBuffer_Tag *vb, const MD_Char *filename);
/*  read the content of buffer from disk file */
MD_Int vec_buffer_binread(struct VecBuffer_Tag *vb, const MD_Char *filename);



#ifdef __cplusplus
}
#endif

#endif

