/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * timer.c
 *
 * Summary:  Used for internal timing.
 */

#include <stdlib.h>

#if defined(LINUX)
#include <sys/time.h>
#include <unistd.h>
#elif defined(SUN)
#include <time.h>
#else
#include <sys/time.h>
#endif
#include "timer.h"

MD_Double time_of_day(void)
{
  struct timeval tm;
  /*
  struct timezone tz;
  gettimeofday(&tm, &tz);
  */

  gettimeofday(&tm, NULL);
  return(((MD_Double) tm.tv_sec) + ((MD_Double) tm.tv_usec)*1e-6);
}

