/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#include "mdtypes.h"

#ifndef SHAKE_H
#define SHAKE_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * rigid water molecule:
 *
 *                  O                O: Oxygen atom
 *                 / \               H: Hydrogen atom
 *             d1 /   \ d1           angle(H1OH2) = theta.
 *               /     \
 *             H1 ----- H2
 *                  d2
 */

  struct Shake_Water {
    MD_Double bondOH, bondHH, angle_HOH; /* constraint for water molecule */
    MD_Double massO, massH;
    MD_Double errTol2;  /* error tolerance square */
    MD_Double bond_errTol;   /* for checking purpose */
    MD_Dvec *old_pos;   /* old position */
    MD_Int natoms;
  };

  void shake_init(struct Shake_Water *sw, const MD_Double bondOH, 
		  const MD_Double angle_HOH, 
		  const MD_Double massO, const MD_Double massH,
		  const MD_Int natoms);

  void shake_destroy(struct Shake_Water *sw);

  void shake_prepare(struct Shake_Water *sw, const MD_Dvec *old_pos);

  /* used with velocity verlet method */
  MD_Errcode shake(struct Shake_Water *sw, const MD_Int iatom, 
		   MD_Dvec *rnew, MD_Dvec *vel, const MD_Double deltaT);

  /* modify position to satisfy constaints, then velocity (vel) at 
   * half time is DEFINED as 
   *        v(n+1/2) = ( r(n+1) - r(n) ) / dt; 
   * used with leapfrog method (e.g. when we use Berendsen rescaling 
   */
  MD_Errcode shake_position(struct Shake_Water *sw, const MD_Int iatom, 
			  MD_Dvec *rnew, MD_Dvec *vel, const MD_Double dt);

#ifdef __cplusplus
}
#endif


#endif
