/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * rebuilt from NAMD2
 */

#ifndef SETTLE_H__
#define SETTLE_H__

#include "mdtypes.h"

/*
 * The original paper is
 * SETTLE: an analytical version of the SHAKE and RATTLE algorithm
 * for rigid water models 
 * Shuichi Miyamoto and Peter Kollman,  Journal of Computational Chemistry
 * Vol 13, 954--962, yr 1992

Oxygen at a0, hydrogens at b0, c0, center of mass at the origin.

                   |
                   |
                   |
                a0 .-------
                   |   |
                   |   ra
                   |   | 
---------------------------------------
           |       |        |
           rb      |---rc---|
           |       |        |
    b0 .-----------|        . c0 
  
SETTLE for step one of velocity verlet.
ref: positions before unconstrained step
mass: masses
pos: on input: positions after unconstrained step; on output: the new 
               positions.
vel: on input: velocities after unconstrained step; on output: the new
               velocities.
ra, rb, rc: canonical positions of water atoms; see above diagram
*/

struct Settle_Water 
{
  MD_Double ra, rb, rc;
  MD_Double mO, mH;
  MD_Dvec *old_pos;   /* old position */
  MD_Int natoms;
};

MD_Errcode settle_init(struct Settle_Water* sw, MD_Double mO, MD_Double mH,
		       MD_Double hhdist, MD_Double ohdist, MD_Int natoms);
MD_Errcode settle_destroy(struct Settle_Water* sw);

void settle_prepare(struct Settle_Water* sw, const MD_Dvec *old_pos);

/* shake */
MD_Errcode settle1(const struct Settle_Water* sw, const MD_Int iatom,
		   MD_Dvec rnew[3], MD_Dvec vel[3], const MD_Double dt);

/* a copy of rattle2 */
MD_Errcode settle2(const struct Settle_Water *rw, const MD_Dvec *r, 
		   MD_Dvec *v, const MD_Double dt);

#endif
