/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#include <math.h>
#include "random.h"

static const int m1 = 502, m2 = 1521, m3 = 4071, m4 = 2107;
static const int n1 = 0  , n2 = 0   , n3 = 2896, n4 = 1167;
static const double tpm12 = 1.0/4096.0;

double rannyu(void) 
{
  static int l1 = 0,   l2 = 0,    l3 = 2896, l4 = 1263;
  int i1 , i2 , i3 , i4 ;

  i1 = l1*m4+l2*m3+l3*m2+l4*m1 + n1;
  i2 = l2*m4+l3*m3+l4*m2 + n2;
  i3 = l3*m4+l4*m3 + n3;
  i4 = l4*m4 + n4;

  l4  = i4 & 4095;
  i3 += i4>>12;
  l3  = i3 & 4095;
  i2 += i3>>12;
  l2  = i2 & 4095;
  l1  = (i1 + (i2>>12)) & 4095;
  return (tpm12*(l1+tpm12*(l2+tpm12*(l3+tpm12*l4))));
}
/******************************************************************/
 
void rannyu_vector3(double *p)
{
  double x, y, s;
  do {
    x = 2. * rannyu() - 1.;
    y = 2. * rannyu() - 1.;
    s = x * x + y * y;
  } while (s > 1.);
  p[2] = 1. - 2. * s;    s = 2. * sqrt (1. - s);
  p[0] = s * x;    p[1] = s * y;
}
/******************************************************************/

void rannyu_angle(double *sintheta, double *costheta) 
{
  double k1, k2, kk;
  do {
    k1 = rannyu();
    k2 = rannyu();
    kk = k1 * k1 + k2 * k2;
  } while (kk > 1.0);
  *sintheta = 2.0 * k1 * k2 / kk;
  if (rannyu() < 0.5) *sintheta = - *sintheta;
  *costheta = (k1 * k1 - k2 * k2) / kk ;
}
/******************************************************************/

double rannyu_normal(void) 
{
  double x, y, r2;
  static int sign = 1;
  static double gaus1 = 0.0, gaus2 = 0.0;
  if (sign) {
    sign = 0;
    do {
      x = -log(rannyu());
      y = -log(rannyu());
      r2 = x * x + y * y;
    } while (r2 > 1. || 0. == r2) ;
    r2 = sqrt(-2. * log(r2) / r2);
    gaus1 = r2 * x;
    gaus2 = r2 * y;
    return gaus1;
  } else {
    sign = 1;
    return gaus2; 
  }
}  

