/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

#ifndef PME_UTILITIES_H
#define PME_UTILITIES_H

#include "utilities.h"

/* transpose(T) = [t1 t2 t3], t1, t2, t3 are column vectors of size 3.
 *
 * [td1]                [d1]                       [d1]
 * [td2] = transpose(T) [d2] for Ttrans_MUL_d,   T [d2] for T_MUL_d
 * [td3]                [d3]                       [d3]
 */
 
#ifdef Ttrans_MUL_d
#undef Ttrans_MUL_d
#endif
#ifdef T_MUL_d
#undef T_MUL_d
#endif
 
#define Ttrans_MUL_d(t1, t2, t3, d1, d2, d3, td1, td2, td3) { \
    (td1) = (t1).x*(d1) + (t2).x*(d2) + (t3).x*(d3);          \
    (td2) = (t1).y*(d1) + (t2).y*(d2) + (t3).y*(d3);          \
    (td3) = (t1).z*(d1) + (t2).z*(d2) + (t3).z*(d3);          \
  }

#define T_MUL_d(t1, t2, t3, d1, d2, d3, td1, td2, td3) { \
    (td1) = (t1).x*(d1) + (t1).y*(d2) + (t1).z*(d3);     \
    (td2) = (t2).x*(d1) + (t2).y*(d2) + (t2).z*(d3);     \
    (td3) = (t3).x*(d1) + (t3).y*(d2) + (t3).z*(d3);     \
  }

#ifdef  CYCLIC_INDEX
#undef  CYCLIC_INDEX
#endif
#define CYCLIC_INDEX(u, K) ((u) < 0 ? ((K)+(u)) : (u))


#endif
