/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * the core part of pme, responsible for computing the reciprocal sum
 */

#ifndef PMERECIP_H
#define PMERECIP_H

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define NEED_FFTW(k) { \
fprintf(stderr, "building and linking fftw libraries is required for pme\n"); \
exit(k); \
}

#include "PmeBase.h"
#include "lattice.h"
#ifdef HAVE_FFTW
#include "rfftw.h"
#endif

  struct PmeParams_Tag;

  struct PmeRecip_Tag   /* reciprocal sum */
  { 
    MD_Dvec *force; 
    MD_Double virial[9];
    MD_Double potential; 

    struct PmeParams_Tag storePmeParams;
    struct PmeGrid_Tag myGrid;
    struct Lattice_Tag lattice;       /* simulation box */
    MD_Dvec* scaled_pos;
    MD_Double *q_arr;   /* grid charge */
    MD_Double *d_arr;   /* grid dipole, g_charge+g_dipole, grid_potential */
    MD_Double *work_arr; /* store temporary variable */
    struct PmeRealSpace_Tag *myRealSpace; /* interpolation, force */
    struct PmeKSpace_Tag *myKSpace;   /* B, C, recip energy and virial */

#ifdef HAVE_FFTW
    rfftwnd_plan forward_plan, backward_plan;
#endif
  };


  MD_Errcode pmerec_init(struct PmeRecip_Tag* rec, 
			 const struct PmeParams_Tag* params);
  MD_Errcode pmerec_destroy(struct PmeRecip_Tag* rec);

  void pmerec_charge_compute(struct PmeRecip_Tag* rec, const MD_Dvec *pos,
			     const MD_Double *charge);

  void pmerec_dipole_setup(struct PmeRecip_Tag* rec, const MD_Dvec *pos,
			   const MD_Double *charge);
  /* given dipole, calculate reciprocal energy, virial and force*/
  void pmerec_dipole_calc(struct PmeRecip_Tag* rec, const MD_Double *charge, 
			  const MD_Double *dipole, const MD_Int calc_d_arr);

  /* flag = 0, compute -G2d, result array length is 3*natoms 
   * flag = 1, compute -G1q - G2d */
  void pmerec_add_pseudores(const struct PmeRecip_Tag* rec,
			    const MD_Double *d, const MD_Int flag, 
			    MD_Double *pseudores);


#ifdef __cplusplus
}
#endif

#endif /* PMERECIP_H */
