/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */



#ifndef PME_DIRECT_H
#define PME_DIRECT_H

#ifdef __cplusplus
extern "C" {
#endif 

#include "mdtypes.h"
#include "pme.h"
#include "linkcell.h"


  struct PmeDirect_Tag {
    /* direct sum, added */
    MD_Dvec* ppos;
    MD_Dvec *force;       /* self-maintained */
    MD_Dvec systemsize;
    MD_Double cutoff;
    MD_Double potential;
    MD_Double virial[9];
    MD_Double *neg_dirG1q; 
    MD_Double **b_arr;    /* per-pair based caching, store B1,B2,B3 */
    MD_Int **neibrlist;   /* neibrlist[i]: i's neighor's atom ID */
    MD_Int *numneibrs;    /* numneibrs[i] = # of neighbors for atom i */
    MD_Int max_neibrs;    /* control needed for memory allocation */
    MD_Int natoms;
    struct LinkCell_Tag *linkcell;
    struct Erfc_Tag* myerfc;
  };

  MD_Errcode pmedir_init(struct PmeDirect_Tag* dir,
			 const struct PmeParams_Tag *params);
  MD_Errcode pmedir_destroy(struct PmeDirect_Tag* dir);

  /* compute charge-charge energy and force */
  void pmedir_charge_compute(struct PmeDirect_Tag* dir, 
			     struct PmeParams_Tag *params,
			     const MD_Double *charge, const MD_Dvec *pos);

  /* compute charge-charge energy, force, -dirG1*q, store B1 array */
  void pmedir_dipole_setup(struct PmeDirect_Tag* dir,
                           struct PmeParams_Tag *params, 
                           const MD_Double *charge, const MD_Dvec *pos);

  void pmedir_dipole_force(struct PmeDirect_Tag* dir, const MD_Dvec *pos, 
			   const MD_Double *charge, const MD_Double* dipole);

  /* flag = 0, compute -G2d, result array length is 3*natoms 
   * flag = 1, compute -G1q - G2d */
  void pmedir_compute_pseudores(struct PmeDirect_Tag* dir, const MD_Double *d,
				const MD_Int flag, MD_Double *pseudores);


#ifdef __cplusplus
}
#endif 
#endif /* PME_DIRECT_H */
