/*
 * Copyright (C) 2006 by David Hardy.  All rights reserved.
 */

/*
 * output_pdb.c
 *
 * Manufacture a coordinate PDB file since the program starts
 * a simulation without one.
 */

#include <stdio.h>
#include "data.h"

int output_pdb(const struct Data_Tag *data, const char *fname)
{
  float occupancy = 1.0;
  float tempFactor = 0.0;
  const char *segID = "BOX1";
  const char *resName = (ARGON == data->model_id ? "ARG" :
      (SPC == data->model_id ? "SPC" : "POL"));
  const char *record = "ATOM  ";
  const char *watname[3] = { "OH2", "H1", "H2" };
  const char *argname[3] = { "AR", "AR", "AR" };
  const char **name = (ARGON == data->model_id ? argname : watname);
  const MD_Dvec *pos = data->pos;
  FILE *f;
  int32 natoms = data->natoms;
  int32 n;

  if (NULL == (f = fopen(fname, "w"))) {
    fprintf(stderr, "fopen() failed\n");
    return MD_FAIL;
  }
  fprintf(f, "REMARK  file created by dpsim\n");
  for (n = 0;  n < natoms;  n++) {
    fprintf(f, "%s%5d  %-3s %3s  %4d    %8.3f%8.3f%8.3f%6.2f%6.2f      %4s\n",
        record, n+1, name[n%3], resName, 1+n/3, pos[n].x, pos[n].y, pos[n].z,
        occupancy, tempFactor, segID);
  }
  fprintf(f, "END\n");
  fclose(f);
  return 0;
}
