/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef NOSE_HOOVER_DYNAMICS_H
#define NOSE_HOOVER_DYNAMICS_H

#include "data.h"
#include "force.h"


#ifdef __cplusplus
extern "C" {
#endif

  struct NoseHoover_Tag
  {
    struct Force_Tag *force;
    struct Data_Tag *data;
    MD_Double temperature;  /* Kelvin */
  
    MD_Double inv_Qmass;    /* inverse of virtual mass */
    MD_Double fricoeff;     /* friction coefficient */
    MD_Double log_s;        /* ln(s) */
    MD_Double degree_freedom; /* degree of freedom of the system */
    MD_Double twice_desired_kinE; /* degree of freedom * temperature */
    MD_Double conserved_psuedoE;  /* nose energy should be conversed */
    MD_Int output_freq;
  };


  MD_Errcode nosehoover_init(struct NoseHoover_Tag *ns, 
			     struct Force_Tag *force,
			     struct Data_Tag *data, 
			     const MD_Double temperature /* Kelvin */ ); 
  MD_Errcode nosehoover_run(struct NoseHoover_Tag *ns, const MD_Int nsteps,
			    enum RUN_TYPE run_type);
  MD_Errcode nosehoover_destroy(struct NoseHoover_Tag *ns);

  void nosehoover_computeH(struct NoseHoover_Tag* nh);
  MD_Double nosehoover_get_pv_over_nkT(const struct  NoseHoover_Tag*nh);


#ifdef __cplusplus
}
#endif


#endif
