/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/********************************************************
*							*
*  LINEARIZATION:					*
*      assume y=k*x+b, find k annd b from a given set   *
*  of data x[i], y[i].					*
*  							*
*  MATH FORMULAE:					*
*							*
*         n*sum(x*y) - sum(x) * sum(y)                  *
*    k = ------------------------------                 *
*         n*sum(x*x) - sum(x) * sum(x)                  *
*							*
*	  sum(x*x) * sum(y) - sum(x*y) * sum(x)         *
*    b = ---------------------------------------        *
*              n*sum(x*x) - sum(x) * sum(x)             *
*							*
*	    cov(x,y) 					*
*    r =  -------------					*
*          sqrt(Dx*Dy)  				*
*							*
*    cov(x,y) = E( (x-Ex)*(y-Ey) );  Dx = E( (x-Ex)^2 ) *
*							*
*    r = 1, means y=k*x+b exactly.			*
*							*
*    err_lin = sum( (y-k*x-b)^2 )			*
*							*
*    err_lin = 0 if y=k*x+b exactly.  			*
*							*
*  INPUT REQUIREMENT:					*
*     the data must be the type MD_Double			*
*							*
********************************************************/

#ifndef LINEARFIT_H
#define LINEARFIT_H

#include "mdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif


struct LinearFit_Tag {
  MD_Int ndata;      /* # of data pointes contained */
  MD_Int nmax;       /* max. number of data points can be put in */
  MD_Double *x, *y;  /* store data */
  MD_Double k, b, r; /* linear-fit result */
  MD_Int computed;   /* bool  */
};


MD_Int linearfit_init(struct LinearFit_Tag *lf, const MD_Int maxsize); 
void linearfit_add_element(struct LinearFit_Tag *lf, const MD_Double xnew, 
			     const MD_Double ynew);
void linearfit_compute(struct LinearFit_Tag *lf);
void linearfit_print_stats(struct LinearFit_Tag *lf, const char *title);
void linearfit_destroy(struct LinearFit_Tag *lf);
MD_Double linearfit_getslope(struct LinearFit_Tag *lf);
MD_Double linearfit_getstart(struct LinearFit_Tag *lf);
MD_Double linearfit_getrelcoeff(struct LinearFit_Tag *lf);
void linearfit_dump_data(struct LinearFit_Tag *lf, const char *filename);
void linearfit_clear(struct LinearFit_Tag *lf);

#ifdef __cplusplus
}
#endif

#endif
