/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * general purpose helper functions
 */

#ifndef HELPER_H
#define HELPER_H

#include <stddef.h>
#include "mdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* compute dot product of two vectors of size n */
  MD_Double DOT(const MD_Double *v1, const MD_Double *v2, const MD_Int n);

  /* compute sum of the elements of the array of size n */
  MD_Double array_sum(const MD_Double *v, const MD_Int n);

  /* output a vector of length n with title to stdout */
  void outputv(const MD_Double *v, const MD_Int n, const char *title);
  void output_vec_array(const MD_Dvec *v, const MD_Int n, const char*title);

  MD_Errcode bindump_vec_array(const MD_Dvec *v, const MD_Int n, 
			       const char* filename);
  MD_Errcode binread_vec_array(MD_Dvec *v, const MD_Int n, 
			       const char* filename);

  MD_Errcode bindump_array(const MD_Double *v, const MD_Int n, 
			   const char* filename);
  MD_Errcode binread_array(MD_Double *v, const MD_Int n, 
			   const char* filename);


  MD_Int my_strcasecmp(register const char *cs, 
		       register const char *ct);

  /* if not enough memory, then exit, "guarantee" the return is OK */
  void *my_malloc(size_t total_size, const char* name);
  void *my_calloc(size_t nmemb, size_t size, const char* name);

/* use gauss elimnation method to solve the linear system
 * assume the size n is less than 20. */
  int GaussElmination(int n, double *a, double *b);
#ifdef __cplusplus
}
#endif

#endif
