/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * force.h
 */

#ifndef FORCE_H
#define FORCE_H

#include "data.h"
#include "fnonbond.h"
/*
#include "fbond.h"
*/

#ifdef __cplusplus
extern "C" {
#endif

struct Force_init_Tag 
{
  struct Data_Tag *data;
  MD_Int restart;
  enum ElectroStatic_Solver_Tag emodule;
  struct Dsolver_Parameters_Type dsolver_param;
};

struct Force_Tag 
{
  struct Data_Tag *data;   /* pointer back to main simulation data */
  struct Fbond_Tag *fbond;  /* bond force */
  struct Fnonbond_Tag *fnonbond;   /* nonbonded forces */
  MD_Dvec *f;           /* total force array */
  MD_Dvec systemsize;   /* init from data */
  MD_Dvec* wrapped_pos; /* wrapped into the unit box */
  MD_Int natoms;        /* number of atoms, the size of "f" array */
  MD_Int restart;       /* =1, restart */
  MD_Int model_id;      /* which physical model is used */
};


/*
 * prototypes
 */
MD_Errcode force_init(struct Force_Tag *force, 
		      struct Force_init_Tag *init_data);
MD_Errcode force_destroy(struct Force_Tag *force);
MD_Errcode force_compute(struct Force_Tag *force);

/* utilities */
void output_exclusion(const struct Force_Tag *force);
void force_output(const struct Force_Tag *force);
MD_Double force_compute_volume(const struct Force_Tag *force);
MD_Errcode force_dump(const struct Force_Tag *force, const char* file);

/* helper function */
void find_nearest_neibr(const struct Force_Tag *force);


#ifdef __cplusplus
}
#endif
#endif /* FORCE_H */
