/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */

/*
 * fnonbond.h  non-bonding forces header file
 */

#ifndef FNONBOND_H
#define FNONBOND_H

#ifdef __cplusplus
extern "C" {
#endif

#include "data.h"
#include "vdw.h"
#include "standEwald.h"
#include "pme.h"
#include "dpoly.h"
#include "utilities.h"

  struct Force_Tag;

  struct Fnonbond_init_Tag {
    struct Force_Tag *force;
    struct Data_Tag *data;
    enum ElectroStatic_Solver_Tag ewaldmethod;
    struct Dsolver_Parameters_Type dsolver_param;
  };

  struct Fnonbond_Tag 
  {
    struct Force_Tag *force; /* back pointer */

    struct VDW_Tag *vdw;  /* van der Waals force */

    enum ElectroStatic_Solver_Tag ewaldmethod;
#ifndef DIPOLE_POLY 
    struct Electro_Tag *electro;  /* electrostatic force */
#else
    void *electro;
#endif

    /*
     * exclusion list for nonbonded interactions
     *
     * this is a jagged matrix with natoms rows, each row contains 
     * a sorted list of atom numbers j for which atom numbered i 
     * has a nonbonded exclusion; each row ends with sentinel INT_MAX
     * list is built during rpol_force_init based on the established
     * exclusion policy with up to 1-4 exclusions depending on simparam
     * setting (if scaled 1-4 interactions are in effect, then list
     * contains only 1-2 and 1-3 exclusions)
     */
    MD_Int **excllist;
    /*
     * scaled 1-4 exclusion list
     * same as above except it contains only 1-4 exclusions
     */
    MD_Int **scaled14;

    MD_Dvec systemsize;        /* base vector of the unit cell */

  };


  /*
   * prototypes
   */
  MD_Errcode fnonbond_init(struct Fnonbond_Tag *fnonbond, 
			 struct Fnonbond_init_Tag *init_data);
  MD_Errcode fnonbond_destroy(struct Fnonbond_Tag *fnonbond);
  MD_Errcode fnonbond_compute(struct Fnonbond_Tag *fnonbond);

  /* utilities */
  MD_Errcode fnonbond_dump(struct Fnonbond_Tag *fnonbond, const char* file);

#ifdef __cplusplus
}
#endif
#endif /* FNONBOND_H */
