/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/* The dipole equation  (G2 + D) d = (-G1q) is solved approximately
 * by d = P(G2) * (-G1q), where P(x) is a polynomial. The polynomial
 * is chosen so that the solution is optimal in either 2-norm or A-norm.
 * 
 */

#include "standEwald.h"


struct dipole_poly_init
{
  struct standEwald_init_Tag e_init;
  MD_Double a;
  MD_Double b;
};

struct Dipole_Poly_Tag
{
  struct standEwald_Tag* se;
  MD_Double a, b;
  MD_Double *dipole;
  MD_Double *aneg_G1q;
};

MD_Errcode dipole_poly_init(struct Dipole_Poly_Tag *dp,
			                struct dipole_poly_init *init_data);
MD_Errcode dipole_poly_destroy(struct Dipole_Poly_Tag *dp);
MD_Errcode dipole_poly_compute(struct Dipole_Poly_Tag *dp);
const MD_Double * dipole_poly_get_dipole(struct Dipole_Poly_Tag *dp);

void dp_compute_mol_sys_dipole(struct Dipole_Poly_Tag *dp,
			       MD_Double *mol_perm_dipole,
			       MD_Double *mol_induc_dipole,
			       MD_Double *mol_total_dipole,
			       MD_Dvec *system_total_dipole);
