/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/*
 * Simple md analyzer module, for simplicity, the analysis components are
 * added manually, there is no registration process.
 * diffusion constant, radial distribution function should be analyzed
 * after the MD run with dumped data, since full analysis of diffusion 
 * constant needs large amount of memory, and full analysis of radial 
 * distribution function is an O(N^2) computation.
 */

#ifndef MD_ANALYZER_H
#define MD_ANALYZER_H

#include "data.h"
#include "force.h"
#include "linearfit.h"
#include "avgvar.h"

#ifdef __cplusplus
extern "C" {
#endif

  enum data_collector_avgvar_components { /* all possible averages */
    AV_kineticE, AV_potentialE_per_mol,
    AV_Msqr, AV_Mx, AV_My, AV_Mz,
    AV_mol_perm_dipole, AV_mol_ind_dipole, AV_mol_tot_dipole,
    /* AV_pv_over_nkT, */
    N_mda_av
  };

  enum data_collector_linearfit_components {
    LF_energy, N_mda_lf
  };


  struct Data_Collector_Tag
  {
    struct Data_Tag *pdata;   /* pointer only, should not change its content */
    struct Force_Tag *pforce; /* pointer only, should not change its content */
    MD_Int n_avgvar;
    struct AvgVar_Tag **avgvar;
    MD_Int n_lf;
    struct LinearFit_Tag **lf;
    enum MD_TYPE md_type;
    Model_Types model_id;
    /* av_index[i_component] gives the real offset of the component in the 
     * avgvar_components array */
    MD_Int av_index[N_mda_av]; 

    void *p_md;  /* kludge */
  };

  void data_collector_init(struct Data_Collector_Tag *data_collector, 
			   struct Data_Tag *data, struct Force_Tag *force,
			   enum MD_TYPE md_type);
  void data_collector_assign_pmd(struct Data_Collector_Tag *data_collector, 
				 void *pmd);
  void data_collector_update(struct Data_Collector_Tag *data_collector, 
			     MD_Int istep);
  void data_collector_output(struct Data_Collector_Tag *data_collector);
  void data_collector_destroy(struct Data_Collector_Tag *data_collector);

#ifdef __cplusplus
}
#endif

  
#endif /* MD_ANALYZER_H */
