/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef CONSTANT_ENERGY_MD_H
#define CONSTANT_ENERGY_MD_H

#include "force.h"
#include "utilities.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* An issue about shake and rattle:
   *   they generate SAME positions at integer timesteps, and
   *                 SAME velocities at half-integer timesteps.
   * However, this does not mean it is arbitrary to use either of them.
   * In velocity-Verlet method, both positions and velocities at 
   *     integer timesteps are needed, so we must use rattle.
   * In leapfrog method, positions at integer timesteps and velocities
   *     at half timesteps are needed, so it is natural to use SHAKE.
   * i.e. we MUST use:
   *     either velocity-Verlet + rattle,   (1)
   *         or        leapfrog + shake     (2)
   * the advantage of (1) is that we know position and velocity at the 
   * same time, the disadvantage of (1) is we need one more step to
   * get the velocity right.
   * the advantage of (2) is we don't need extra step to make velocity right.
   * the disadvantage is we don't know positon and velocity at the 
   * same time.
   */

MD_Errcode constEnergy_MD_run(struct Force_Tag *force, const MD_Int nsteps,
			      const enum RUN_TYPE run_type);

MD_Errcode leapfrog_MD_run(struct Force_Tag *force, const MD_Int nsteps,
			   const enum RUN_TYPE run_type);

#ifdef __cplusplus
}
#endif

#endif
