/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


/* 
 * simple module to compute the average and variance of the data array
 * 
 */
#ifndef AVGVAR_H
#define AVGVAR_H

#include <stdio.h>
#include "mdtypes.h"
#include "utilities.h"

#ifdef __cplusplus
extern "C" {
#endif

struct AvgVar_Tag 
{
  MD_Int nelements;  /* # of elements */
  MD_Int array_size; /* allocated array size */
  MD_Double* data;
  MD_Double average; 
  MD_Double variance;
  MD_String title;    /* description name of the module */
  MD_Int computed;    /* BOOLEAN value */
};

void avgvar_init(struct AvgVar_Tag *av, const MD_Int size, const char* title);
void avgvar_add(struct AvgVar_Tag *av, MD_Double element);
void avgvar_output(struct AvgVar_Tag *av);
void avgvar_destroy(struct AvgVar_Tag *av);
MD_Double avgvar_get_avg(struct AvgVar_Tag *av);
MD_Double avgvar_get_var(struct AvgVar_Tag *av);
void avgvar_dump_data(struct AvgVar_Tag *av, FILE* fid);  

#ifdef __cplusplus
}
#endif

#endif
