/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef DIFFUSION_CONSTANT_H
#define DIFFUSION_CONSTANT_H


#include "mdtypes.h"

/* calculate the autocorrelation function of a physical quantity,
 * (e.g. velocity)
 *   C(t) = <v(t) \cdot v(0) > / <v(t)v(t)>
 * the largest t is specified in initialization by an input.
 */

struct Auto_Corr_Tag
{
  MD_String name;         /* the physical quantity (vector) name */
  MD_Int timelen;         /* time length for computing the correlation */
  MD_Dvec* v0;            /* v(0) */
  MD_Int veclen;          /* length of v(0): # of vectors */
  MD_Int current_tim;
  MD_Double dt;
  MD_Double* corr;        /* correlation function of size timelen */
  MD_Int* counter;
};


MD_Int autocorr_init(struct Auto_Corr_Tag* ac,
		     const MD_String name,
		     const MD_Int timelen, 
		     const MD_Int veclen, 
		     const MD_Double dt);
void autocorr_destroy(struct Auto_Corr_Tag* ac);
void autocorr_update(struct Auto_Corr_Tag* ac, const MD_Dvec* vel);
void autocorr_output(struct Auto_Corr_Tag* ac, char *filename);
void autocorr_print(struct Auto_Corr_Tag* ac);



#endif
