/*
 * Copyright (C) 2004-2006 by Wei Wang.  All rights reserved.
 */


#ifndef PME_K_SPACE_H
#define PME_K_SPACE_H

#ifdef __cplusplus
extern "C" {
#endif


#include "PmeBase.h"
#include "lattice.h"

  struct PmeKSpace_Tag  /* diagonal B, C, reciprocal energy and virial */
  {
    MD_Double *bm1, *bm2, *bm3; 
    MD_Double *exp1, *exp2, *exp3;
    /* MD_Double piob, i_pi_volume; ==> local variable */
    struct PmeGrid_Tag myGrid;
  };

  MD_Errcode pmekspace_init(struct PmeKSpace_Tag *, struct PmeGrid_Tag *);
  MD_Errcode pmekspace_destroy(struct PmeKSpace_Tag *pks);

  void pmekspace_charge_calc_enrgvir(struct PmeKSpace_Tag *pks, 
				     MD_Double *q_arr, 
				     struct Lattice_Tag lattice,
				     const MD_Double ewald, 
				     MD_Double *Energy, 
				     MD_Double virial[9]);

  /* ------------------------------------------------------------------ */
  void pmekspace_init_exp(struct PmeKSpace_Tag *pks, 
			  const struct Lattice_Tag lattice,
			  const MD_Double ewaldcof);
  void pmekspace_apply_potential(const struct PmeKSpace_Tag *pks, 
				 const struct Lattice_Tag lattice,
				 MD_Double *s_arr);
  /* only part of the virial is computed */
  void pmekspace_dipole_calc_enrgvir(struct PmeKSpace_Tag *pks, 
				     MD_Double *d_arr, 
				     struct Lattice_Tag lattice,
				     MD_Double ewaldcof,
				     MD_Double *Energy, 
				     MD_Double virial[9]);
#ifdef __cplusplus
}
#endif

#endif /* PME_K_SPACE_H */
